#include <libgda/libgda.h>

int
main (int argc, char *argv[])
{
        GdaConnection* connection;
        GError* error = NULL;
	GdaMetaStore *store;
	GdaSqlParser *parser;
	GdaStatement *stmt;
	gint res;
	gchar tableName;
	GdaMetaContext mcontext = {"_tables", 1, NULL, NULL};

        gda_init();
        error = NULL;

        /* open connection */
	printf("Start.\n");
	printf("Open connection.\n");
        connection = gda_connection_open_from_dsn ("stocksql", NULL, GDA_CONNECTION_OPTIONS_NONE, &error);
        if (!connection) 
	{
                fprintf (stderr, "%s\n", error->message);
                return -1;
        }

	/* Open Meta Store */
	printf("Open Meta Store.\n");
	store = gda_meta_store_new_with_file("/tmp/single.db");
	g_object_set(G_OBJECT(connection), "meta-store", store, NULL);
	if (!store)
	{
		printf("Can not open store.\n");
		return -1;
	}

	/* Drop table xparts */
	printf("Drop table xparts (if exists).\n");
	parser = gda_connection_create_parser(connection);
	if (!parser)
		parser = gda_sql_parser_new();
	
	stmt = gda_sql_parser_parse_string(parser, "DROP TABLE xparts", NULL, &error);
	g_object_unref(parser);
	if (!stmt) 
	{
                fprintf (stderr, "%s\n", error->message);
                return -1;
        }
	else
	{
		res = gda_connection_statement_execute_non_select (connection, stmt, NULL, NULL, &error);
		if (res == -1)
		{ 
			/* Ignore error, as the goal is to not have this table */
		}
	}

	/* Clean Up */
	g_object_unref(stmt);

	/* Build Complete store */
	printf("Build complete store.\n");
	if (!gda_connection_update_meta_store(connection, NULL, NULL))
	{
		printf("Can not update store.\n");
		return -1;
	}

	/* Create table xparts */
	printf("Create table xparts.\n");
	parser = gda_connection_create_parser(connection);
	if (!parser)
		parser = gda_sql_parser_new();
	
	stmt = gda_sql_parser_parse_string(parser, "CREATE TABLE xparts (part_id varchar(5) PRIMARY KEY, description varchar(30))", NULL, &error);
	g_object_unref(parser);
	if (!stmt) 
	{
                fprintf (stderr, "%s\n", error->message);
                return -1;
        }
	else
	{
		res = gda_connection_statement_execute_non_select (connection, stmt, NULL, NULL, &error);
		if (res == -1) 
		{
                	fprintf (stderr, "%s\n", error->message);
			return -1;
		}
	}

	/* Clean up */	
	g_object_unref(stmt);

	/* Update store for just a SINGLE table */
	printf("Update Meta Store with SINGLE table.\n");
	mcontext.column_names = g_new (gchar *, 1);
	mcontext.column_names[0] = "table_name";
	mcontext.column_values = g_new (GValue *, 1);
	tableName = gda_sql_identifier_quote("xparts", connection, NULL, TRUE, FALSE);
	g_value_set_string ((mcontext.column_values[0] = gda_value_new(G_TYPE_STRING)), tableName);
	g_free(tableName);
	if (!gda_connection_update_meta_store(connection, &mcontext, &error))
	{
                fprintf (stderr, "%s\n", error->message);
                return -1;
	}
	
	/* Clean up */	
	gda_value_free (mcontext.column_values[0]);
	
	/* The End */
	printf("End.\n");
	return 0;
}
