/*
 * Copyright (c) 1999 G. Adam Stanislav
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	libutf-8 v.1
 */

#include <stdio.h>

unsigned int fgetu8(FILE *);
int fputu8(unsigned int, FILE *);
unsigned int sgetu8(unsigned char *, int *);
char * sputu8(unsigned int, char *);

/*
 * These functions are defined as macros.
 * They will be called as functions if utf-8.h
 * is not included.
 */
unsigned int utf8fgetc(FILE *input) { return fgetu8(input); }
unsigned int utf8getc(FILE *input) { return fgetu8(input); }
unsigned int utf8getchar() { return fgetu8(stdin); }
int utf8fputc(unsigned int c, FILE *output) { return fputu8(c, output); }
int utf8putc(unsigned int c, FILE *output) { return fputu8(c, output); }
int utf8putchar(unsigned int c) { return fputu8(c, stdout); }
unsigned int utf8sgetc(unsigned char *str, int *chars) { return sgetu8(str, chars); }
char * utf8sputc(unsigned int c, char *str) { return sputu8(c, str); }

