# Translate Groff font names to AFM file names
# AdobePS	- PS names of Adobe fonts	Courier
# URWPS		- PS names of URW fonts		NimbusMonL-Regu
# AdobeKB	- Berry named Adobe fonts	pcrr8a
# URWKB		- Berry named URW fonts		ucrr8a
# AdobeShort	- short names for Adobe fonts	couri
# AdobeVendor	- vendor names for Adobe fonts	com_____
# URWVendor	- vendor names for URW fonts	n022003l

function AdobePS {
case "$1" in
AB)	echo "AvantGarde-Demi"			;;
ABI)	echo "AvantGarde-DemiOblique"		;;
AI)	echo "AvantGarde-BookOblique"		;;
AR)	echo "AvantGarde-Book"			;;
BMB)	echo "Bookman-Demi"			;;
BMBI)	echo "Bookman-DemiItalic"		;;
BMI)	echo "Bookman-LightItalic"		;;
BMR)	echo "Bookman-Light"			;;
CB)	echo "Courier-Bold"			;;
CBI)	echo "Courier-BoldOblique"		;;
CI)	echo "Courier-Oblique"			;;
CR)	echo "Courier"				;;
HNB)	echo "Helvetica-Narrow-Bold"		;;
HNBI)	echo "Helvetica-Narrow-BoldOblique"	;;
HNI)	echo "Helvetica-Narrow-Oblique"		;;
HNR)	echo "Helvetica-Narrow"			;;
HB)	echo "Helvetica-Bold"			;;
HBI)	echo "Helvetica-BoldOblique"		;;
HI)	echo "Helvetica-Oblique"		;;
HR)	echo "Helvetica"			;;
NB)	echo "NewCenturySchlbk-Bold"		;;
NBI)	echo "NewCenturySchlbk-BoldItalic"	;;
NI)	echo "NewCenturySchlbk-Italic"		;;
NR)	echo "NewCenturySchlbk-Roman"		;;
PB)	echo "Palatino-Bold"			;;
PBI)	echo "Palatino-BoldItalic"		;;
PI)	echo "Palatino-Italic"			;;
PR)	echo "Palatino-Roman"			;;
S)	echo "Symbol"				;;
SS)	echo "Symbol-Slanted"			;;
TB)	echo "Times-Bold"			;;
TBI)	echo "Times-BoldItalic"			;;
TI)	echo "Times-Italic"			;;
TR)	echo "Times-Roman"			;;
ZCMI)	echo "ZapfChancery-MediumItalic"	;;
ZD)	echo "ZapfDingbats"			;;
ZDR)	echo "ZapfDingbats-Reverse"		;;
esac
}

function AdobeKB {
case "$1" in
AB)	echo "pagd8a"	;;
ABI)	echo "pagdo8a"	;;
AR)	echo "pagk8a"	;;
AI)	echo "pagko8a"	;;
BMB)	echo "pbkd8a"	;;
BMBI)	echo "pbkdi8a"	;;
BMR)	echo "pbkl8a"	;;
BMI)	echo "pbkli8a"	;;
CB)	echo "pcrb8a"	;;
CBI)	echo "pcrbo8a"	;;
CR)	echo "pcrr8a"	;;
CI)	echo "pcrro8a"	;;
HB)	echo "phvb8a"	;;
HNB)	echo "phvb8an"	;;
HBI)	echo "phvbo8a"	;;
HNBI)	echo "phvbo8an"	;;
HR)	echo "phvr8a"	;;
HNR)	echo "phvr8an"	;;
HI)	echo "phvro8a"	;;
HNI)	echo "phvro8an"	;;
NB)	echo "pncb8a"	;;
NBI)	echo "pncbi8a"	;;
NR)	echo "pncr8a"	;;
NI)	echo "pncri8a"	;;
PB)	echo "pplb8a"	;;
PBI)	echo "pplbi8a"	;;
PR)	echo "pplr8a"	;;
PI)	echo "pplri8a"	;;
S)	echo "psyr"	;;
TB)	echo "ptmb8a"	;;
TBI)	echo "ptmbi8a"	;;
TR)	echo "ptmr8a"	;;
TI)	echo "ptmri8a"	;;
ZCMI)	echo "pzcmi8a"	;;
ZD)	echo "pzdr"	;;
esac
}

function AdobeShort {
case "$1" in
AR)	echo "avangbk"	;;
AI)	echo "avangbko"	;;
AB)	echo "avangd"	;;
ABI)	echo "avangdo"	;;
BMB)	echo "bookmd"	;;
BMBI)	echo "bookmdi"	;;
BMR)	echo "bookml"	;;
BMI)	echo "bookmli"	;;
CR)	echo "couri"	;;
CB)	echo "courib"	;;
CBI)	echo "couribo"	;;
CI)	echo "courio"	;;
HR)	echo "helve"	;;
HB)	echo "helveb"	;;
HBI)	echo "helvebo"	;;
HNR)	echo "helven"	;;
HNB)	echo "helvenb"	;;
HNBI)	echo "helvenbo"	;;
HNI)	echo "helveno"	;;
HI)	echo "helveo"	;;
NB)	echo "newcsb"	;;
NBI)	echo "newcsbi"	;;
NI)	echo "newcsi"	;;
NR)	echo "newcsr"	;;
PB)	echo "palatb"	;;
PBI)	echo "palatbi"	;;
PI)	echo "palati"	;;
PR)	echo "palatr"	;;
S)	echo "symbol"	;;
TB)	echo "timesb"	;;
TBI)	echo "timesbi"	;;
TI)	echo "timesi"	;;
TR)	echo "timesr"	;;
ZCMI)	echo "zapfcmi"	;;
esac
}

function AdobeVendor {
case "$1" in
AB)	echo "agd_____"	;;
ABI)	echo "agdo____"	;;
AR)	echo "agw_____"	;;
AI)	echo "agwo____"	;;
BMB)	echo "bkd_____"	;;
BMBI)	echo "bkdi____"	;;
BMR)	echo "bkl_____"	;;
BMI)	echo "bkli____"	;;
CB)	echo "cob_____"	;;
CBI)	echo "cobo____"	;;
CR)	echo "com_____"	;;
CI)	echo "coo_____"	;;
HB)	echo "hvb_____"	;;
HNB)	echo "hvnb____"	;;
HBI)	echo "hvbo____"	;;
HNBI)	echo "hvnbo___"	;;
HR)	echo "hv______"	;;
HNR)	echo "hvn_____"	;;
HI)	echo "hvo_____"	;;
HNI)	echo "hvno____"	;;
NB)	echo "ncb_____"	;;
NBI)	echo "ncbi____"	;;
NR)	echo "ncr_____"	;;
NI)	echo "nci_____"	;;
PB)	echo "pob_____"	;;
PBI)	echo "pobi____"	;;
PR)	echo "por_____"	;;
PI)	echo "poi_____"	;;
S)	echo "sy______"	;;
TB)	echo "tib_____"	;;
TBI)	echo "tibi____"	;;
TR)	echo "tir_____"	;;
TI)	echo "tii_____"	;;
ZCMI)	echo "zcmi____"	;;
ZD)	echo "zd______"	;;
esac
}

function URWPS {
case "$1" in
ABU)	echo "URWGothicL-Demi"		;;
ABIU)	echo "URWGothicL-DemiObli"	;;
ARU)	echo "URWGothicL-Book"		;;
AIU)	echo "URWGothicL-BookObli"	;;
BMBU)	echo "URWBookmanL-DemiBold"	;;
BMBIU)	echo "URWBookmanL-DemiBoldItal"	;;
BMRU)	echo "URWBookmanL-Ligh"		;;
BMIU)	echo "URWBookmanL-LighItal"	;;
CBU)	echo "NimbusMonL-Bold"		;;
CBIU)	echo "NimbusMonL-BoldObli"	;;
CRU)	echo "NimbusMonL-Regu"		;;
CIU)	echo "NimbusMonL-ReguObli"	;;
HBU)	echo "NimbusSanL-Bold"		;;
HNBU)	echo "NimbusSanL-BoldCond"	;;
HBIU)	echo "NimbusSanL-BoldItal"	;;
HNBIU)	echo "NimbusSanL-BoldCondItal"	;;
HRU)	echo "NimbusSanL-Regu"		;;
HNRU)	echo "NimbusSanL-ReguCond"	;;
HIU)	echo "NimbusSanL-ReguItal"	;;
HNIU)	echo "NimbusSanL-ReguCondItal"	;;
NBU)	echo "CenturySchL-Bold"		;;
NBIU)	echo "CenturySchL-BoldItal"	;;
NRU)	echo "CenturySchL-Roma"		;;
NIU)	echo "CenturySchL-Ital"		;;
PBU)	echo "URWPalladioL-Bold"	;;
PBIU)	echo "URWPalladioL-BoldItal"	;;
PRU)	echo "URWPalladioL-Roma"	;;
PIU)	echo "URWPalladioL-Ital"	;;
SU)	echo "StandardSymL"		;;
TBU)	echo "NimbusRomNo9L-Medi"	;;
TBIU)	echo "NimbusRomNo9L-MediItal"	;;
TRU)	echo "NimbusRomNo9L-Regu"	;;
TIU)	echo "NimbusRomNo9L-ReguItal"	;;
ZCMIU)	echo "URWChanceryL-MediItal"	;;
ZDU)	echo "Dingbats"			;;
esac
}

function URWKB {
case "$1" in
ABU)	echo "uagd8a"	;;
ABIU)	echo "uagdo8a"	;;
ARU)	echo "uagk8a"	;;
AIU)	echo "uagko8a"	;;
BMBU)	echo "ubkd8a"	;;
BMBIU)	echo "ubkdi8a"	;;
BMRU)	echo "ubkl8a"	;;
BMIU)	echo "ubkli8a"	;;
CBU)	echo "ucrb8a"	;;
CBIU)	echo "ucrbo8a"	;;
CRU)	echo "ucrr8a"	;;
CIU)	echo "ucrro8a"	;;
HBU)	echo "uhvb8a"	;;
HNBU)	echo "uhvb8ac"	;;
HBIU)	echo "uhvbo8a"	;;
HNBIU)	echo "uhvbo8ac"	;;
HRU)	echo "uhvr8a"	;;
HNRU)	echo "uhvr8ac"	;;
HIU)	echo "uhvro8a"	;;
HNIU)	echo "uhvro8ac"	;;
NBU)	echo "uncb8a"	;;
NBIU)	echo "uncbi8a"	;;
NRU)	echo "uncr8a"	;;
NIU)	echo "uncri8a"	;;
PBU)	echo "uplb8a"	;;
PBIU)	echo "uplbi8a"	;;
PRU)	echo "uplr8a"	;;
PIU)	echo "uplri8a"	;;
SU)	echo "usyr"	;;
TBU)	echo "utmb8a"	;;
TBIU)	echo "utmbi8a"	;;
TRU)	echo "utmr8a"	;;
TIU)	echo "utmri8a"	;;
ZCMIU)	echo "uzcmi8a"	;;
ZDU)	echo "uzdr"	;;
esac
}

function URWVendor {
case "$1" in
ABU)	echo "a010015l"	;;
ABIU)	echo "a010035l"	;;
ARU)	echo "a010013l"	;;
AIU)	echo "a010033l"	;;
BMBU)	echo "b018015l"	;;
BMBIU)	echo "b018035l"	;;
BMRU)	echo "b018012l"	;;
BMIU)	echo "b018032l"	;;
CBU)	echo "n022004l"	;;
CBIU)	echo "n022024l"	;;
CRU)	echo "n022003l"	;;
CIU)	echo "n022023l"	;;
HBU)	echo "n019004l"	;;
HNBU)	echo "n019044l"	;;
HBIU)	echo "n019024l"	;;
HNBIU)	echo "n019064l"	;;
HRU)	echo "n019003l"	;;
HNRU)	echo "n019043l"	;;
HIU)	echo "n019023l"	;;
HNIU)	echo "n019063l"	;;
NBU)	echo "c059016l"	;;
NBIU)	echo "c059036l"	;;
NRU)	echo "c059013l"	;;
NIU)	echo "c059033l"	;;
PBU)	echo "p052004l"	;;
PBIU)	echo "p052024l"	;;
PRU)	echo "p052003l"	;;
PIU)	echo "p052023l"	;;
SU)	echo "s050000l"	;;
TBU)	echo "n021004l"	;;
TBIU)	echo "n021024l"	;;
TRU)	echo "n021003l"	;;
TIU)	echo "n021023l"	;;
ZCMIU)	echo "z003034l"	;;
ZDU)	echo "d050000l"	;;
esac
}

if [ $2 ] ; then
 echo `$1 $2`
else
 echo $1
fi
