
%-+------- geometry of blades

  /blade [              % coordinates: [x y x y ...]

  69.2  -3.8  68.8  -3.1  67.5  -2.3  65.3  -1.3  62.4  -0.2  58.6   1.2
  54.1   2.7  48.9   4.4  43.1   6.2  36.6   8.2  29.7  10.3  22.3  12.4
  14.6  14.3   6.6  16.2  -1.5  17.8  -9.8  19.1 -18.1  20.0 -26.2  20.4
 -34.2  20.4 -41.9  19.8 -49.3  18.8 -56.2  17.4 -62.7  15.6 -68.5  13.5
 -73.7  11.2 -78.2   8.8 -82.0   6.2 -84.9   3.7 -87.1   1.2 -88.4  -1.3
 -88.8  -3.7 -88.4  -6.0 -87.1  -8.3 -84.9 -10.4 -82.0 -12.5 -78.2 -14.4
 -73.7 -16.1 -68.5 -17.6 -62.7 -18.9 -56.2 -19.9 -49.3 -20.5 -41.9 -20.8
 -34.2 -20.8 -26.2 -20.4 -18.1 -19.6  -9.8 -18.6  -1.5 -17.4   6.6 -16.0
  14.6 -14.6  22.3 -13.2  29.7 -11.8  36.6 -10.5  43.1  -9.4  48.9  -8.4
  54.1  -7.5  58.6  -6.8  62.4  -6.1  65.3  -5.6  67.5  -5.0  68.8  -4.4] def

  /r1 497 def           % radius, annulus
  /r2 625 def           % radius, annulus
  /rb 552 def           % radius, blade placement
  /rh  30 def           % radius, blade hub
  /rs   8 def           % radius, spigot
  /al  30 def           % blade angle
  /nb  24 def           % number of blades
  /df 360 nb div def    % delta-phi: blade-pitch

%-+------- routine to draw a single blade

/draw-blade {                                           % draw a single blade

gsave df mul rotate 0 rb translate al neg rotate        % get it in position

  0.50 setlinewidth                                     % thin lines

  0.60 setgray 0 0 rh _circ fill                        % hub

  1.00 setgray blade _r _c gsave fill grestore          % blade inside

  0.00 setgray stroke                                   % blade contour

  0.60 setgray 0 0 rs _circ fill                        % spigot

  0.20 setgray -16 0 _m 16 0 _d 0 -12 _m 0 12 _d stroke % centre-lines

  1 0 0 setrgbcolor 2 setlinewidth                      % thick red lines

  blade 64 16 getinterval _r stroke                     % damaged area in red

grestore

} _b

%-+------- action: annulus + all blades (clipped)

gsave u1 2 add v1 u2 2 sub v2 _rect clip _n             % clipping rectangle

  u1 u2 add 2 div -103 translate                        % guide-vane sys origin

  0.26 dup scale                                        % scale the system

  0.88 setgray 0 0 r1 r2 _annu fill                     % draw annulus

  0 1 nb 1 sub { draw-blade } for                       % all blades, clipped

grestore

%--------- 
