#ifndef GSL_MARRAY_H_INCLUDED
#define GSL_MARRAY_H_INCLUDED

#include <gsl_marray_meta.h>


/** ====================== generic rank multi-array types ================== */


typedef struct
{
  const double *       data;
  gsl_marray_metadata  metadata;
}
gsl_const_marray_impl;

typedef struct
{
  double *             data;
  gsl_marray_metadata  metadata;
}
gsl_marray_impl;


typedef union
{
  gsl_const_marray_impl  const_impl;
}
gsl_const_marray;

typedef union
{
  gsl_const_marray_impl  const_impl;
  gsl_marray_impl        impl;
}
gsl_const_marray;


/** ====================== static rank multi-array types ================== */

typedef struct
{
  const double *         data;
  gsl_marray_metadata_1  metadata;  
}
gsl_const_marray_1_impl;

typedef struct
{
  double *               data;
  gsl_marray_metadata_1  metadata;
}
gsl_marray_1_impl;


typedef union
{
  gsl_const_marray_1_impl const_impl;
}
gsl_const_marray_1;

typedef union
{
  gsl_const_marray_1_impl const_impl; 
  gsl_marray_1_impl       impl;
}
gsl_marray_1;



typedef struct
{
  const double *         data;
  gsl_marray_metadata_2  metadata;
}
gsl_const_marray_2_impl;

typedef struct
{
  double *               data;
  gsl_marray_metadata_2  metadata;
}
gsl_marray_2_impl;


typedef union
{
  gsl_const_marray_2_impl const_impl;
}
gsl_const_marray_2;

typedef union
{
  gsl_const_marray_2_impl const_impl; 
  gsl_marray_2_impl       impl;
}
gsl_marray_2;



typedef struct
{
  const double *         data;
  gsl_marray_metadata_3  metadata;
}
gsl_const_marray_3_impl;

typedef struct
{
  double *               data;
  gsl_marray_metadata_3  metadata;
}
gsl_marray_3_impl;


typedef union
{
  gsl_const_marray_3_impl const_impl;
}
gsl_const_marray_3;

typedef union
{
  gsl_const_marray_3_impl const_impl; 
  gsl_marray_3_impl       impl;
}
gsl_marray_3;


/** ====================== return-by-value constructors ======================*/


gsl_const_marray_1
gsl_const_marray_1_view(const double * d, const gsl_marray_idx shape[]);

gsl_marray_1
gsl_marray_1_view(double * d, const gsl_marray_idx shape[]);

gsl_marray_1
gsl_marray_1_build(const gsl_marray_idx shape[]);


gsl_const_marray_2
gsl_const_marray_2_view(const double * d, const gsl_marray_idx shape[]);

gsl_marray_2
gsl_marray_2_view(double * d, const gsl_marray_idx shape[]);

gsl_marray_2
gsl_marray_2_build(const gsl_marray_idx shape[]);


gsl_const_marray_3
gsl_const_marray_3_view(const double * d, const gsl_marray_idx shape[]);

gsl_marray_3
gsl_marray_3_view(double * d, const gsl_marray_idx shape[]);

gsl_marray_3
gsl_marray_3_build(const gsl_marray_idx shape[]);



/** ====================== "in-place" destructors =========================== */


void gsl_marray_release_data(gsl_marray * ma);



/** ====================== heap constructors ================================ */


gsl_const_marray_1 *
gsl_const_marray_1_view_new(const double * d, const gsl_marray_idx shape[]);

gsl_marray_1 *
gsl_marray_1_view_new(double * d, const gsl_marray_idx shape[]);

gsl_marray_1 *
gsl_marray_1_new(const gsl_marray_idx shape[]);


gsl_const_marray_2 *
gsl_const_marray_2_view_new(const double * d, const gsl_marray_idx shape[]);

gsl_marray_2 *
gsl_marray_2_view_new(double * d, const gsl_marray_idx shape[]);

gsl_marray_2 *
gsl_marray_2_new(const gsl_marray_idx shape[]);


gsl_const_marray_3 *
gsl_const_marray_3_view_new(const double * d, const gsl_marray_idx shape[]);

gsl_marray_3 *
gsl_marray_3_view_new(double * d, const gsl_marray_idx shape[]);

gsl_marray_3 *
gsl_marray_3_new(const gsl_marray_idx shape[]);



/** ====================== heap destructors ================================ */


void gsl_const_marray_free(gsl_const_marray * ma);
void gsl_marray_free(gsl_marray * ma);



/** ======================== indexing ===================================== */


int gsl_marray_1_offset(const gsl_const_marray_1_impl * ma, int index);
int gsl_marray_2_offset(const gsl_const_marray_2_impl * ma, const int i[]); 
int gsl_marray_3_offset(const gsl_const_marray_3_impl * ma, const int i[]);
int gsl_marray_4_offset(const gsl_const_marray_4_impl * ma, const int i[]);



/** ======================== slicing ===================================== */

/** Slice a rank one multi-array. There is only one meaningful notion of
 *  slicing for the rank one case, a restriction slice. This selects the
 *  equivalent of a "subvector".
 */
gsl_marray_1
gsl_marray_1_slice(const gsl_marray_1 * ma, gsl_marray_idx_slice slice);

gsl_const_marray_1
gsl_const_marray_1_slice(const gsl_const_marray_1 * ma, gsl_marray_idx_slice slice);


/** Slice a rank two multi-array by restriction. The result
 *  is another rank two object, although it may be compressible.
 */
gsl_marray_2
gsl_marray_2_slice_restrict(const gsl_marray_2 * ma, const gsl_marray_idx_slice slice[]);

gsl_const_marray_2
gsl_const_marray_2_slice_restrict(const gsl_const_marray_2 * ma, const gsl_marray_idx_slice slice[]);


/** Slice a general rank one multi-array out of a rank two. Allows for
 *  things like "extracting the diagonal" and all similar operations.
 */
gsl_marray_1
gsl_marray_2_slice_1(const gsl_marray_2 * ma, const int begin[], const int delta[]);

gsl_const_marray_1
gsl_const_marray_2_slice_1(const gsl_const_marray_2 * ma, const int begin[], const int delta[]);



/** FIXME: Obviously we need more functions, for slicing higher rank
 *  objects, etc. Tedious, but straightforward.
 */


#endif  /* !GSL_MARRAY_H_INCLUDED*/
