#ifndef GSL_MARRAY_META_H_INCLUDED
#define GSL_MARRAY_META_H_INCLUDED

#include <gsl_marray_idx.h>


/** Metadata structure for multi-arrays. All containers
 *  expressing the multi-array concept do so through
 *  use of this family of structures.
 */


enum {
  GSL_MARRAY_STORAGE_C = 0,
  GSL_MARRAY_STORAGE_F = 1
};

enum {
  GSL_MARRAY_PACKING_UNKNOWN = 0,  // arbitrary/unknown
  GSL_MARRAY_PACKING_BLOCKED = 1,  // fast index is contiguous
  GSL_MARRAY_PACKING_TIGHT = 2     // data is entirely contiguous
};


/** Base type. */
typedef struct
{
  int  rank;      // number of indices (size of shape array)
  char owner;     // ownership of data pointer
  char storage;   // storage order (better to say index order)
  char packing;   // packing hints
  char _reserved;
  gsl_marray_idx idx[1];  // shape
}
gsl_marray_metadata;



/** Types for static ranks. */

typedef struct
{
  int  rank;
  char owner;
  char storage;
  char packing;
  char _reserved;
  gsl_marray_idx idx[1];
}
gsl_marray_metadata_1;


typedef struct
{
  int  rank;
  char owner;
  char storage;
  char packing;
  char _reserved;
  gsl_marray_idx idx[2];
}
gsl_marray_metadata_2;


typedef struct
{
  int  rank;
  char owner;
  char storage;
  char packing;
  char _reserved;
  gsl_marray_idx idx[3];
}
gsl_marray_metadata_3;



/** Initialize metadata in place. This function, like the rest of this
 *  metadata component, is not meant for use by regular clients.
 */
void
gsl_marray_metadata_init(gsl_marray_metadata * md, int rank, int owner, int storage, const int dims[]);


/** Compress metadata. See gsl_marray_idx_compress().
 */
int
gsl_marray_metadata_compress(gsl_marray_metadata * md);



#endif  /* !GSL_MARRAY_META_H_INCLUDED*/
