#ifndef GSL_MATRIX_H_INCLUDED
#define GSL_MATRIX_H_INCLUDED

#include <gsl_marray.h>


enum
{
  GSL_MATRIX_ROW_MAJOR = GSL_MARRAY_STORAGE_C,
  GSL_MATRIX_COL_MAJOR = GSL_MARRAY_STORAGE_F
};



typedef struct
{
  const double *         data;
  gsl_marray_metadata_2  metadata;
}
gsl_const_matrix_impl;

typedef struct
{
  double *               data;
  gsl_marray_metadata_2  metadata;
}
gsl_matrix;


typedef union
{
  gsl_const_marray_2_impl  const_base;
  gsl_const_matrix_impl    const_impl;
}
gsl_const_matrix;

typedef union
{
  gsl_const_marray_2_impl  const_base; 
  gsl_const_matrix_impl    const_impl;
  gsl_marray_2_impl        base;
  gsl_matrix_impl          impl;
}
gsl_matrix;




/** Similar to the type imposters for deprecated vector
 *  containers. The deprecated matrix types support only
 *  row-major access, otherwise the 'tda' element would
 *  be in the wrong place! As for the deprecated vectors,
 *  some function support would be needed to turn this
 *  into a complete solution.
 */

typedef struct
{
  const double * data;
  int            rank;
  char           owner;
  char           storage;
  char           packing;
  char           _reserved;
  int            size1;
  int            tda;
  int            size2;
  int            _hidden;
}
gsl_deprecated_const_matrix;

typedef struct
{
  double * data;
  int      rank;
  int      owner;
  int      dimens_slow;
  int      stride_slow;
  int      dimens_fast;
  int      _hidden;
  int      storage_order;
}
gsl_deprecated_matrix;



/** ====================== return-by-value constructors ======================*/

gsl_const_matrix
gsl_const_matrix_view(const double * d, int num_rows, int num_cols, int tda);

gsl_matrix
gsl_matrix_view(double * d, int num_rows, int num_cols, int tda);

gsl_matrix
gsl_matrix_build(int num_rows, int num_cols);



/** ====================== "in-place" destructors =========================== */

void gsl_matrix_release_data(gsl_matrix * m);



/** ====================== heap constructors ================================ */

gsl_const_matrix *
gsl_const_matrix_view_new(const double * d, int num_rows, int num_cols, int tda);

gsl_matrix *
gsl_matrix_view_new(double * d, int num_rows, int num_cols, int tda);

gsl_matrix *
gsl_matrix_new(int num_rows, int num_cols);



/** ====================== heap destructors ================================ */

void gsl_const_matrix_free(gsl_const_matrix * m);
void gsl_matrix_free(gsl_matrix * m);



/** ======================== indexing ===================================== */

int gsl_matrix_offset(const gsl_const_matrix_impl * m, int i_row, int i_col);



/** ======================== slicing ===================================== */

/** Here are some specialized examples of supported slices. Of course,
 *  the general slicing mechanism for multi-arrays is available, through
 *  the multi-array functions.
 */

gsl_vector
gsl_matrix_slice_diagonal(const gsl_matrix * m);

gsl_const_vector
gsl_const_matrix_slice_diagonal(const gsl_const_matrix * m);


gsl_vector
gsl_matrix_slice_offdiagonal(const gsl_matrix * m, int displacement);

gsl_const_vector
gsl_const_matrix_slice_offdiagonal(const gsl_const_matrix * m, int displacement);


gsl_vector
gsl_matrix_slice_row(const gsl_matrix * m, int row);

gsl_const_vector
gsl_const_matrix_slice_row(const gsl_const_matrix * m, int row);


gsl_vector
gsl_matrix_slice_col(const gsl_matrix * m, int col);

gsl_const_vector
gsl_const_matrix_slice_col(const gsl_const_matrix * m, int col);



#endif  /* !GSL_MATRIX_H_INCLUDED*/
