#ifndef GSL_VECTOR_H_INCLUDED
#define GSL_VECTOR_H_INCLUDED

#include <gsl_marray.h> // wherever...


typedef struct
{
  const double * data;
  int            rank;
  int            dimens;
  int            stride;
}
gsl_const_vector_ref;

typedef struct
{
  double * data;
  int      rank;
  int      dimens;
  int      stride;
}
gsl_vector_ref;

typedef struct
{
  double * data;
  int      rank;
  int      dimens;
  int      stride;
}
gsl_vector;



/** ======================== indexing ===================================== */

/** Indexing is the main operation which benefits from static (compile-time)
 *  knowledge of the rank. I have declared these in a normal way, assuming
 *  a compiled implementation; however, they will eventually be declared
 *  and implemented as inline functions.
 */

int gsl_vector_offset(const gsl_const_vector_ref * v, int index);




#endif  /* !GSL_VECTOR_H_INCLUDED*/
