#include <iostream>
#include <libgdamm-3.0/libgdamm.h>
#include <libgnomedbmm.h>

int main(int argc, char **argv)
{
  Gnome::Gda::init("Test", "0.1", argc, argv);

  Glib::RefPtr<Gnome::Gda::Dict> dict = Gnome::Gda::Dict::create();

  Glib::RefPtr<Gnome::Gda::Query> query = Gnome::Gda::Query::create(dict);
  try
    { 
      query->set_sql_text("SELECT * FROM table LIMIT 10");
    }
  catch(const Glib::Error& e)
    { 
      std::cerr << e.what() << std::endl;
      exit(1);
    }

  return (0); 
}
