

module Main where

import Partition
import Permutation
import SampleGraphs
import Nauty
import Data.Graph
import Data.Array 

import Data.List(nub)
import System.Random

naut1 = buildG (1,6) [(1,2), (2,3), (3,1), (1,4), (2,5), (5,6)]

naut2 = buildG (1,7)
	[(1,2), (2,3), (3,4), (4,5), (5,1),
	 (3,6), (6,7), (7,4),
	 (2,6)]




nex1 = buildG (1, 6)
      [ (1,2), (2,3), (3,1), 
	(1,4), (2,5), (3,6) ]



cleanG = fmap nub

cae = cleanG $ undirG $ buildG (0,9) $ edges (prismG 4) ++ 
	 [ (8,0), (8,1), (8,2), (8,3),
           (9,4), (9,5), (9,6), (9,7) ]



main = process $ hCubeG 6


process (gr0::Graph) =
     do randG <- newStdGen
	let perm :: Permutation = randomPerm (bounds gr0) randG
	let gr :: Graph = applyPerm perm gr0
	putStrLn $ "initial:"
	print gr
	let (aut, result) = canonicGraph gr
	putStrLn "Automorphism group generator:"
	putStrLn $ show aut
	putStrLn "Canonic labelling:"
	putStrLn $ show result
