
-- This an implementation of the canonic labeling of graphs + automorphism group.
-- J.P. Bernardy -- 2003

-- The implementation is based on

-- Brendan D. McKay, PRACTICAL GRAPH ISOMORPHISM,
-- in Congressus Numerantium, Vol. 30 (1981), pp. 45-87.

-- The following source code is distributed under the conditions of the GPL


module Nests(initialPartition, discretePartition, splittingCell, childPartitions) where

import Partition
import Data.Graph(Graph, Vertex)
import Data.Array 
import Permutation
import Data.List(sort)

initialPartition :: Graph -> Partition
initialPartition gr = refine gr pi pi 
    where pi = unitPartition (bounds gr)

discretePartition :: Graph -> Partition
discretePartition gr = map (: []) (range $ bounds gr)

splittingCell :: Partition -> Cell
splittingCell = head . filter (not . isSingleton) 

splitPartition :: Partition -> [(Vertex, Partition)]
splitPartition [] = []
splitPartition (c1:cs1) = 
    if isSingleton c1 
        then [(v, c1:cs2) | (v,cs2) <- splitPartition cs1]
        else [(v, c2:[v]:cs1) | (v, c2) <- splitCell c1]


-- splitCell [x,y,z] = [(x,[y,z]), (y,[x,z]), (z, [x,y])]
splitCell :: Cell -> [(Vertex, Cell)]
splitCell [] = []
splitCell (v:c) = (v, c) : [(v2, v:c2) | (v2, c2) <- splitCell c]


childPartitions :: Graph -> Partition -> [(Vertex, Partition)]
childPartitions gr p =
    [(n, refine gr p [[n]]) | (n,p) <- (splitPartition p)]



