
-- This an implementation of the canonic labeling of graphs + automorphism group.
-- J.P. Bernardy -- 2003

-- The following source code is distributed under the conditions of the GPL

-- This module does some mundane stuff.

module Permutation(Permutation, randomPerm, fixed, permBetween, applyPerm, orbitsFromPerm, mergePerms) where

import Shuffle
import Data.Array
import Data.List
import Data.Graph
import Data.Tree(flatten)
import Data.Array.ST(STUArray, readArray, writeArray, newArray, MArray)
import Control.Monad.ST(runST, ST)
import System.Random
type Permutation = Array Vertex Vertex


-------------------------------------------------------------
-- Generation of random permutations (debugging purposes)

randomPerm :: RandomGen g => (Vertex, Vertex) -> g -> Permutation
randomPerm bnds@(low, high) g = listArray bnds $ shuffle1 (range bnds) (randomList (high-low) g)

--randomList :: RandomGen g => Int g-> [Int]
randomList 0 g = []
randomList n g = x:randomList (n-1) g'
    where (x, g') = randomR (0,n) g


-----------------------------------------
-- Fixed vertex of a given permutation

fixed perm = [i | i <- range $ bounds perm, perm!i == i]


-- builds the permutation taking l1 on l2 (2 discrete partitions)
permBetween bnds l1 l2 = array bnds [(head s, head t) | s <- l1 | t <- l2]


applyPerm :: Permutation -> Graph -> Graph
applyPerm perm gr = array bnds [(perm!x, sort $ map (perm!) (gr!x)) | x <- range bnds]
    where bnds = bounds gr


permAsGraph = fmap (\x-> [x])


orbitsFromPerm perm = map flatten $ dff $ permAsGraph $ perm

permFromOrbits :: Bounds -> [[Vertex]] -> Permutation 
permFromOrbits bnds orbits = array bnds $ concat $ map cycleOf $ orbits
    where cycleOf' first (v1:v2:vs) = (v1, v2) : cycleOf' first (v2:vs)
	  cycleOf' first (v:[]) = [(v, first)]
	  cycleOf orbit@(v:_) = cycleOf' v orbit


mergePerms p1 p2 = permFromOrbits (bounds p1) $
		   map flatten $
		   dff $
		   listArray (bounds p1) [[v1, v2]
					  | v1 <- elems p1 
					  | v2 <- elems p2]

