
module SampleGraphs(hCubeG, cycleG, prismG, productG, starG, unionG, undirG) where

import Data.Graph
import Data.List(nub)
import Data.Array(bounds, (!))


arcG = undirG $ buildG (0,1) [(0,1)]
vertexG = buildG (0, 0) []
triG = cycleG 3
cubeG = hCubeG 3

prismG n = productG arcG (cycleG n)

hCubeG n = powerG n arcG

powerG :: Int -> Graph -> Graph
powerG n gr
    |n == 0 = vertexG
    |n >  0 = productG gr (powerG (n-1) gr)

kG n m = undirG $ buildG (1, n+m) [(x,y) | x <- [1..n], y <- [n+1..n+m]]
	
cycleG n = buildG (1,n) ((n,1) : [(i, i+1) | i <- [1..n-1] ])

starG (l,h) = buildG (l,h) [(l,i) | i <- [l+1..h]]


cliqueG (l,h)
    | l == h = buildG (l,h) []
    | l <  h = unionG (starG (l,h)) (cliqueG (l+1, h))


unionG g1 g2 = buildG (low, high) (edges g1 ++ edges g2)
	       where low = min low1 low2
		     high = max high1 high2
		     (low1, high1) = bounds g1
		     (low2, high2) = bounds g2

undirG g = unionG g (transposeG g)

type PVertex = (Vertex, Vertex)


isNeighbour :: Graph -> Vertex -> Vertex -> Bool
isNeighbour gr n1 n2 = n2 `elem` gr!n1

gen1 g1 g2 (x1, x2) (y1, y2) = 
	isNeighbour g1 x1 y1 && x2 == y2 ||
	isNeighbour g2 x2 y2 && x1 == y1

gen2 g1 g2 (x1, x2) (y1, y2) = 
	isNeighbour g1 x1 y1 ||
	isNeighbour g2 x2 y2 

gen3 g1 g2 (x1, x2) (y1, y2) = 
	isNeighbour g1 x1 y1 &&
	isNeighbour g2 x2 y2 

productGen (f::Graph->Graph->PVertex -> PVertex -> Bool) g1 g2 =
	buildG bnds [ (renumber v1, renumber v2) | v1 <- vx, v2 <- vx, f g1 g2 v1 v2]
  where vx = [ (x, y) | x <- vertices1, y <- vertices2 ]
        vertices1 = vertices g1
        vertices2 = vertices g2
	(low1, high1) = bounds g1
	(low2, high2) = bounds g2
        renumber (v1, v2) = (v1-low1) + (high1-low1+1) * (v2-low2)
	bnds = (renumber (low1, low2), renumber (high1, high2))

productG = productGen gen1

