/*
 * Copyright (c) 2012,13 A. Mosca
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * - The name of the author may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/** @addtogroup pls
 * @{
 */

/** @file	pls.h
 */

#ifndef PLS_H__
#define PLS_H__

#define PLS_VERSION "0.4.0"

#ifndef FS_NAME_MAX
#define FS_NAME_MAX 255
#endif

#ifndef MAX
#define MAX(X,Y) ((X) > (Y) ? (X) : (Y))
#endif

typedef enum {
	CMD_SUCCESS = 0,
	CMD_MINOR_FAILURE = 1,
	CMD_CRITICAL_FAILURE = 2
} cmd_return_t;

typedef struct stat_node stat_node_t;
typedef struct stat_name stat_name_t;

struct stat_node {
	char 		name[FS_NAME_MAX + 1];
	uint16_t 	row;
	uint16_t 	column;
	uint8_t 	tab;
	uint16_t 	length;		/* MAX_PATH ? */
	char		append;
	fs_handle_t 	fs_handle;	/* int16_t */
	service_id_t	service_id;	/* uint32_t */
	fs_index_t 	index;		/* uint32_t */
	unsigned int 	lnkcnt;		/* number of hard links */
	bool 		is_dir;
	aoff64_t 	size;    	/* uint64_t */
/*	service_id_t	service; */
	stat_node_t*    next;
};

struct stat_name {
	char 	name[FS_NAME_MAX + 1];
	struct stat_name*    next;
};

/* Format options are grouped */
#define FMTOPT_COLUMN	(1 << 0)	/* Column view (default) */
#define FMTOPT_LINE	(1 << 1)	/* Line view */
#define FMTOPT_MULTI	(1 << 2)	/* Multiline (one line per entry) */
#define FMTOPT_BRIEF	(1 << 3)
#define FMTOPT_COUNT	(1 << 4)

/* Sort, Adorn, Extra options that do not require stat are grouped */
#define SOPT_NONE	(1 << 0)	/* Do not sort */
#define SOPT_REVERSE	(1 << 1)	/* Reverse sorting */
#define AOPT_QUOTING	(1 << 2)	/* Filename quoting */
#define EOPT_SPACING	(1 << 3)	/* Filename spacing */
#define EOPT_AUTOWIDTH	(1 << 4)	/* Assume terminal width */

/* Sort, Fields, Adorn, Extra options that require stat are grouped */
#define SOPT_NAME	0		/* Sort by name (default) */
#define SOPT_INDEX	(1 << 0)	/* Sort by inode number */
#define SOPT_SIZE	(1 << 1)	/* Sort by size */
#define SOPT_OWNER	(1 << 2)
#define SOPT_GROUP	(1 << 3)
#define SOPT_ATIME	(1 << 4)
#define SOPT_MTIME	(1 << 5)
#define SOPT_CTIME	(1 << 6)
#define SOPT_GROUPDIRS	(1 << 7)
#define SOPT_EXCL	((1 << 8) - 1)	/* Mutually exclusive sort options */

#define FOPT_FSHANDLE	(1 << 11)
#define FOPT_SERVICE_ID	(1 << 12)
#define FOPT_INDEX 	(1 << 13)	/* inode */
#define FOPT_LNKCNT	(1 << 14)
#define FOPT_SIZE	(1 << 15)
/* #define FOPT_SERVICE	(1 << 16) */
#define FOPT_OWNER	(1 << 17)
#define FOPT_GROUP	(1 << 18)
#define FOPT_PERMS	(1 << 19)
#define FOPT_ATIME	(1 << 20)
#define FOPT_MTIME	(1 << 21)
#define FOPT_CTIME	(1 << 22)
#define AOPT_APPENDS	(1 << 23)	/* Append file type indicator */
#define AOPT_COLORS	(1 << 24)	/* Use colors to diplay names */
#define AOPT_READABLE	(1 << 25)	/* Human readable size format */
#define AOPT_USENAMES	(1 << 26)	/* Use names for owner and group */
#define AOPT_TIMEFORMAT	(1 << 27)	/* Specify time format */
#define AOPT_RECURSIVE	(1 << 28)	/* Recursive */
#define EOPT_COUNT	(1 << 29)

#define DEFAULT_COLUMNS 80
#define MIN_COLUMNS	40 		/* Min VGA text mode */
#define MAX_COLUMNS	144
#define DEFAULT_SPACING	2
#define MIN_SPACING	1
#define MAX_SPACING	12
#define DIR_COLOR	COLOR_BLUE
#define MAX_SIZE_STRING 11
#define NUMERIC_SEPARATOR '.'

int main(int, char **); /* avoid clang warning */
static void help_cmd_pls(void);
static void sanitize_options(void);
static int scan_dir(const char *, bool);
static int scan_file(const char *);
static stat_node_t *add_node(stat_node_t *, char *, struct stat *);
static void fill_node(stat_node_t *, struct stat *);
static void print_nodes(stat_node_t *);
static void free_nodes(stat_node_t *);
static void free_names(stat_name_t *);
static void get_console(void);
static void drop_console(console_ctrl_t *);
static stat_node_t *reverse_nodes(stat_node_t *);
static int extra_chars(stat_node_t *);
static void print_entry(stat_node_t *);
static void update_col_view(stat_node_t *, int);
static bool recalculate_col_view(stat_node_t *, int);
static int max_columns(stat_node_t *);
static int longest_col(stat_node_t *, int);
static void update_line_view(stat_node_t *, int);
static bool recalculate_line_view(stat_node_t *);
static int calculate_rows(stat_node_t *);
static int calculate_columns(stat_node_t *);
static int count_nodes(stat_node_t *);
static void readable_size(aoff64_t, char *);
static uint8_t longest_size(stat_node_t *);
static uint8_t longest_index(stat_node_t *);
static int scan_recur_dir(const char *);
static stat_name_t *get_subdir_name(stat_name_t *, char *);
static int safe_exit(stat_node_t *,stat_name_t *, int);
#endif /* PLS_H__ */

/** @}
 */
