#ifndef	_stack_user_
#define	_stack_user_

/* Module stack */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include "stack_types.h"

/* Routine initialize */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t stack_initialize
#if	defined(LINTLIBRARY)
    (server, stack_data)
	mach_port_t server;
	stack_data_t *stack_data;
{ return stack_initialize(server, stack_data); }
#else
(
	mach_port_t server,
	stack_data_t *stack_data
);
#endif

/* Routine push */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t stack_push
#if	defined(LINTLIBRARY)
    (server, data, stack_data)
	mach_port_t server;
	int data;
	stack_data_t *stack_data;
{ return stack_push(server, data, stack_data); }
#else
(
	mach_port_t server,
	int data,
	stack_data_t *stack_data
);
#endif

/* Routine pop */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t stack_pop
#if	defined(LINTLIBRARY)
    (server, stack_data, pop_data)
	mach_port_t server;
	stack_data_t *stack_data;
	int *pop_data;
{ return stack_pop(server, stack_data, pop_data); }
#else
(
	mach_port_t server,
	stack_data_t *stack_data,
	int *pop_data
);
#endif

/* Routine top */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t stack_top
#if	defined(LINTLIBRARY)
    (server, stack_data, top_data)
	mach_port_t server;
	stack_data_t stack_data;
	int *top_data;
{ return stack_top(server, stack_data, top_data); }
#else
(
	mach_port_t server,
	stack_data_t stack_data,
	int *top_data
);
#endif

/* Routine empty */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t stack_empty
#if	defined(LINTLIBRARY)
    (server, stack_data)
	mach_port_t server;
	stack_data_t *stack_data;
{ return stack_empty(server, stack_data); }
#else
(
	mach_port_t server,
	stack_data_t *stack_data
);
#endif

/* Routine uninitialize */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t stack_uninitialize
#if	defined(LINTLIBRARY)
    (server, stack_data)
	mach_port_t server;
	stack_data_t *stack_data;
{ return stack_uninitialize(server, stack_data); }
#else
(
	mach_port_t server,
	stack_data_t *stack_data
);
#endif

#endif	/* not defined(_stack_user_) */
