/* Sample Hurd Stack Client

   Copyright (C) 2003 Free Software Foundation, Inc.
   Written by : V. Varadhan  <v.varadhan@cdclinux.com>

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  
*/

#include <hurd.h>
#include <stdio.h>
#include <mach.h>
#include <fcntl.h>

#include "stack.h"

#define ERROR_STACK_OVERFLOW  -250001
#define ERROR_STACK_UNDERFLOW -250002
#define ERROR_STACK_EMPTY     -250003

int
main (int argc, char* argv[])
{
  file_t stack_server_port_file;
  kern_return_t kr;
  stack_data_t stack_data;

  stack_server_port_file = file_name_lookup ("/tmp/stack", 0, 0);

  if (stack_server_port_file == MACH_PORT_NULL)
    error (1, errno, "Server not found");

  kr = stack_initialize (stack_server_port_file, &stack_data);
  if (kr == KERN_SUCCESS)
    printf ("Stack : Initialize : Success!!\n");
  else
    printf ("Stack : Initialize : failed coz of %s\n", mach_error_string (kr));

  for (;;)
    {
      char        command[2];
      int data;
      int i;

      printf ("stack-> ");
      if (scanf("%1s", command) < 1)
	{
	  printf("\n");
	  break;
	}
      switch (command[0])
	{
	case '?':
	case 'h':
	  printf("Commands:\n");
	  printf ("p <int>   - push an integer in to the stack\n");
	  printf ("o         - pop an integern from the stack\n");
	  printf ("t         - returns the top of the stack\n");
	  printf ("e         - empty the stack\n");
	  printf ("q         - quits the client\n");
	  break;
	case 'p':
	  /*
	    Do a push operation in to the stack.
	  */
	  if (scanf ("%d", &data) < 1)
	    {
	      printf ("Syntax error - push!!\n");
	      break;
	    }
	  kr = stack_push (stack_server_port_file, data, &stack_data);
	  if (kr == KERN_SUCCESS)
	    {
	      printf ("Displaying the contents of the stack : \n");
	      for (i = stack_data.top-1; i > -1 ; i--)
		printf ("%d\n", stack_data.data[i]);
	    }
	  else if (kr == ERROR_STACK_OVERFLOW)
	    printf ("Stack : Push : failed coz of Stack overflow!!\n");
	  else
	    printf ("Stack : Push : failed coz of %s\n", mach_error_string (kr));
	  break;

	case 'o':
	  /*
	    Do a pop operation from the stack.
	  */
	  kr = stack_pop (stack_server_port_file, &stack_data, &data);
	  if (kr == KERN_SUCCESS)
	    {
	      printf ("Popped element from the stack is %d\n", data);
	      printf ("Displaying the contents of the stack : \n");
	      for (i = stack_data.top-1; i > -1 ; i--)
		printf ("%d\n", stack_data.data[i]);
	    }
	  else if (kr == ERROR_STACK_UNDERFLOW)
	    printf ("Stack : Pop : failed coz of Stack underflow!!\n");
	  else
	    printf ("Stack : Pop : failed coz of %s\n", mach_error_string (kr));
	  break;

	case 't':
	  /*
	    Do a top operation in to the stack.
	  */
	  kr = stack_top (stack_server_port_file, stack_data, &data);
	  if (kr == KERN_SUCCESS)
	    {
	      printf ("Top element of the stack is %d\n", data);
	      printf ("Displaying the contents of the stack : \n");
	      for (i = stack_data.top-1; i > -1 ; i--)
		printf ("%d\n", stack_data.data[i]);
	    }
	  else if (kr == ERROR_STACK_EMPTY)
	    printf ("Stack : Top : failed coz of Stack empty!!\n");
	  else
	    printf ("Stack : Top : failed coz of %s\n", mach_error_string (kr));
	  break;

	case 'e':
	  /*
	    Do an empty operation in to the stack.
	  */
	  kr = stack_empty (stack_server_port_file, &stack_data);
	  if (kr == KERN_SUCCESS)
	    {
	      printf ("Displaying the contents of the stack : \n");
	      for (i = stack_data.top-1; i > -1 ; i--)
		printf ("%d\n", stack_data.data[i]);
	    }
	  else
	    printf ("Stack : Empty : failed coz of %s\n", mach_error_string (kr));
	  break;
	case 'q':
	  exit (0);
	}
    }
  exit (0);
}
