/* Sample Hurd Stack Server - Stack methods definition file.

   Copyright (C) 2003 Free Software Foundation, Inc.
   Written by : V. Varadhan  <v.varadhan@cdclinux.com>

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  
*/
#include <mach.h>
#include "stack_types.h"

#define ERROR_STACK_OVERFLOW  -250001
#define ERROR_STACK_UNDERFLOW -250002
#define ERROR_STACK_EMPTY     -250003

kern_return_t 
do_initialize (mach_port_t server, 
	       stack_data_t* stack_data_p)
{
  stack_data_p->top = 0;
  memset (stack_data_p->data, 0x00, 10 * sizeof (int));
  return KERN_SUCCESS;
}

kern_return_t 
do_push (mach_port_t server,
	 int data,
	 stack_data_t* stack_data_p)
{
  kern_return_t retval;
  if (stack_data_p->top < 10)
    {
      stack_data_p->data[stack_data_p->top] = data;
      stack_data_p->top++;
      retval = KERN_SUCCESS;
    }
  else
    {
      printf ("Data overflow!!\n");
      retval = ERROR_STACK_OVERFLOW;
    }
  return retval;
}

kern_return_t 
do_pop (mach_port_t server,
	stack_data_t* stack_data_p,
	int* popped_data_p)
{
  kern_return_t retval;
  if (stack_data_p->top > 0)
    {
#ifdef DEBUG
      printf ("Element popped up from the stack is %d\n", 
	      stack_data_p->data[stack_data_p->top-1]);
#endif
      *popped_data_p = stack_data_p->data[stack_data_p->top-1];
      stack_data_p->top--;
      stack_data_p->data[stack_data_p->top] = 0;
      retval = KERN_SUCCESS;
    }
  else
    {
      printf ("Stack underflow!!\n");
      retval = ERROR_STACK_UNDERFLOW;
    }
  return retval;
}

kern_return_t 
do_top (mach_port_t server,
	stack_data_t stack_data,
	int* top_data_p)
{
  kern_return_t retval;
  if (stack_data.top > 0)
    {
#ifdef DEBUG
      printf ("Element popped up from the stack is %d\n", 
	      stack_data.data[stack_data.top-1]);
#endif
      *top_data_p = stack_data.data[stack_data.top-1];
      retval = KERN_SUCCESS;
    }
  else
    {
      printf ("Stack is empty!!\n");
      retval = ERROR_STACK_EMPTY;
    }
  return retval;
}

kern_return_t 
do_empty (mach_port_t server,
	  stack_data_t* stack_data_p)
{
  kern_return_t retval;
  if (stack_data_p->top > 0)
    {
      memset (stack_data_p->data, 0x00, stack_data_p->top * sizeof (int));
      stack_data_p->top = 0;
      retval = KERN_SUCCESS;
    }
  else
    {
      printf ("Stack is already empty!!\n");
      retval = KERN_FAILURE;
    }
  return retval;
}

kern_return_t 
do_uninitialize (mach_port_t server,
		 stack_data_t* stack_data_p)
{
  memset (stack_data_p->data, 0x00, 10 * sizeof (int));
  stack_data_p->top = 0;
  return KERN_SUCCESS;
}
