/* Sample Hurd Stack Server 

   Copyright (C) 2003 Free Software Foundation, Inc.
   Written by : V. Varadhan  <v.varadhan@cdclinux.com>

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  
*/
#include <stdio.h>
#include <mach.h>
#include <argp.h>
#include <fcntl.h>

#include <hurd/ports.h>
#include <hurd/trivfs.h>

#define MAX_MSG_SIZE                           512

extern boolean_t stack_server (mach_msg_header_t *InHeadP, 
			       mach_msg_header_t *OutHeadP);

int trivfs_fstype = FSTYPE_MISC;
int trivfs_fsid = 0;
int trivfs_support_read = 0;
int trivfs_support_write = 0;
int trivfs_support_exec = 0;
int trivfs_allow_open = 0x00;
int trivfs_protid_nportclasses = 0;
int trivfs_cntl_nportclasses = 0;

/*
extern boolean_t fsys_server (mach_msg_header_t *InHeadP, 
			      mach_msg_header_t *OutHeadP);
*/
static boolean_t
my_stack_server (mach_msg_header_t *InHeadP,
		 mach_msg_header_t *OutHeadP)
{
  return stack_server (InHeadP, OutHeadP) || trivfs_demuxer (InHeadP, OutHeadP);
}

void trivfs_modify_stat (struct trivfs_protid *cred, io_statbuf_t  *st)
{
}
error_t trivfs_goaway (struct trivfs_control *fsys, int flags)
{
  exit (0);
}

#ifdef _NO_TRIVFS_
int
main ()
{
  error_t err;
  mach_port_t bootstrap, right;

  printf ("Before task_get_bootstrap_port \n");
  task_get_bootstrap_port (mach_task_self (), &bootstrap);
  if (bootstrap == MACH_PORT_NULL)
    error (1, 0, "Must be started as a translator");

  printf ("Before mach_port_allocate \n");

  mach_port_allocate (mach_task_self(), 
			     MACH_PORT_RIGHT_RECEIVE, &stack_service);
  /*mach_port_insert_right (mach_task_self(), stack_service,
			  stack_service, MACH_MSG_TYPE_MAKE_SEND);
  */
  /*err = fsys_startup (bootstrap, stack_service, MACH_MSG_TYPE_MAKE_SEND, &real_stack_node);*/
  printf ("After mach_port_allocate \n");

  stack_bucket = (struct port_bucket *) ports_create_bucket ();
  stack_class = (struct port_class *) ports_create_class (NULL, NULL);
  //  err = ports_create_port (stack_class, stack_bucket, sizeof (mach_port_t),
  //			   &stack_control);
  //  if (err)
  //    error (3, err, "Stack: ports_create_port:\n");

  right = ports_get_send_right (&stack_service);

  err = fsys_startup (bootstrap, 0, right, 
		      MACH_MSG_TYPE_COPY_SEND, &real_stack_node);
  if (err)
    error (1, err, "Starting up the translator!!\n");
  ports_port_deref (&stack_control);

  mach_port_deallocate (mach_task_self (), right);
  mach_port_deallocate (mach_task_self (), bootstrap);

  ports_import_port (stack_class, stack_bucket, real_stack_node, 
		     sizeof (mach_port_t), &stack_control);

  printf ("started as a translator\n");
  ports_manage_port_operations_one_thread (stack_bucket, stack_server, 0);
  return 0;
}
#endif
int
main ()
{
  error_t err;
  static struct trivfs_control *fsys;
  mach_port_t bootstrap, right;

  printf ("Before task_get_bootstrap_port \n");
  task_get_bootstrap_port (mach_task_self (), &bootstrap);
  if (bootstrap == MACH_PORT_NULL)
    error (1, 0, "Must be started as a translator");

  printf ("Before mach_port_allocate \n");

  err = trivfs_startup (bootstrap, 0, 0, 0, 0, 0, &fsys);
  mach_port_deallocate (mach_task_self(), bootstrap);
  
  if (err)
    error (3, err, "Contacting parent\n");

  ports_manage_port_operations_one_thread (fsys->pi.bucket, my_stack_server, 0); 

}
