#include <stdio.h>
#include <libtasn1.h>
#include <stdint.h>
#include "test_asn1_tab.c"

// Verify ASN.1 result
#define VR(r) if(ASN1_SUCCESS!=r) fprintf(stderr, "%s: %d ASN1 error: [%s]\n", \
    __FILE__, __LINE__, asn1_strerror(r));
// Verify ASN.1 result with a description
#define VRD(r) if(ASN1_SUCCESS!=r) fprintf(stderr, "%s: %d ASN1 error: [%s] : [%s]\n", \
    __FILE__, __LINE__, asn1_strerror(r), errorDescription);

int main(void)
{
  ASN1_TYPE defs=NULL, s=NULL;
  char errorDescription[ASN1_MAX_ERROR_DESCRIPTION_SIZE]={0};
  int r;
  uint8_t enc[100];
  int enclen=sizeof(enc);

  FILE *fp;

  r=asn1_array2tree(test_asn1_tab, &defs, errorDescription); VRD(r);
  r=asn1_create_element(defs,"Test-20160411.S", &s); VR(r);

  r=asn1_write_value(s, "V", "Value", 0); VR(r);
  r=asn1_write_value(s, "O", "Optional" , 0); VR(r);
  r=asn1_der_coding(s,"", enc, &enclen, errorDescription); VRD(r);

  fp=fopen("vr.dat", "wb");
  fwrite(enc, 1, enclen, fp);
  fclose(fp);

  asn1_delete_structure(&s);
  asn1_delete_structure(&defs);

  return 0;
}
