#!/usr/bin/perl
# 
# make_defaults_cc.pl
#
# A perl script that generates defaults.cc from defaults.xml
#
# Part of the ht://Dig package   <http://www.htdig.org/>
# Copyright (c) 1995-2000 The ht://Dig Group
# For copyright details, see the file COPYING in your distribution
# or the GNU Public License version 2 or later
# <http://www.gnu.org/copyleft/gpl.html>
#
# $Id$
#

require "manage_attributes.pl";

# This script takes one command line argument, being the 
# name of the output file

sub mydie
{
   local($msg) = @_;

   if ( $OutputFile && -r $OutputFile )
   {
      unlink( $OutputFile );
   }
   die $msg;
}

$OutputFile = $ARGV[0];

$OutputFile || 
   &mydie( "No output file was specified" );  

open ( OutFP, ">$OutputFile" ) ||
   &mydie( "Unable to open $OutputFile for writing" );

&LoadAttributeData( 0 ) ||
   &mydie("Errors in Attribute Data Set");

print OutFP <<EOF;
//
// defaults.cc - this is AUTOMATICALLY GENERATED FILE. If
//     you need to change any thing here you should change
//     defaults.xml and then run
//
//       make_defaults_cc.pl < defaults.xml > defaults.cc
//
// defaults: default values for the ht programs through the
//           HtConfiguration class
//
// Part of the ht://Dig package   <http://www.htdig.org/>
// Copyright (c) 1995-2000 The ht://Dig Group
// For copyright details, see the file COPYING in your distribution
// or the GNU Public License version 2 or later
// <http://www.gnu.org/copyleft/gpl.html>
//

#ifdef HAVE_CONFIG_H
#include "htconfig.h"
#endif /* HAVE_CONFIG_H */

#include "HtConfiguration.h"

ConfigDefaults  defaults[] =
{
EOF

foreach $varname ( &GetAttributeNames() )
{
   $attrdata = &GetAttributeData( $varname );

   $value = $attrdata->{ "default" };
  
   if ( ! $attrdata->{ "macro" } )
   {
       $value =~ s/"/\\"/g;
       $value = "\"$value\"";
   }  

   print OutFP "{\"$varname\",$value},\n";
}

print OutFP <<EOF;
{0, 0}
};

HtConfiguration config;
EOF
