//
// Configuration.h
//
// This class provides an object lookup table.  Each object in the Configuration
// is indexed with a string.  The objects can be returned by mentioning their
// string index.
//
// $Id: Configuration.h,v 1.2 1997/07/03 17:44:38 turtle Exp $
//
// $Log: Configuration.h,v $
// Revision 1.2  1997/07/03 17:44:38  turtle
// Added support for virtual hosts
//
// Revision 1.1.1.1  1997/02/03 17:11:04  turtle
// Initial CVS
//
//
#ifndef	_Configuration2_h_
#define	_Configuration2_h_

#include "Dictionary.h"
#include <htconfig.h>
#include <Configuration.h>
#include <URL.h>

/* class String; */


/* struct ConfigDefaults */
/* { */
/*     char	*name; */
/*     char	*value; */
/* }; */


class Configuration2 : public Object
{
public:
    //
    // Construction/Destruction
    //
    Configuration2();

    Configuration2(const Configuration2& config) :
      dcGlobalVars(config.dcGlobalVars),
      dcServers(config.dcServers),
      dcUrls(config.dcUrls),
      separators(config.separators)
      {
        allow_multiple = config.allow_multiple;
      }

    ~Configuration2();

    //
    // Adding and deleting items to and from the Configuration
    //
    void		Add(char *name, char *value);
    void		Add(char *str);
    void		Add(char *name, char *value, Configuration *aList);
    int			Remove(char *name);

    //
    // Let the Configuration know how to parse name value pairs
    //
    void		NameValueSeparators(char *s);
	
    //
    // We need some way of reading in the database from a configuration file
    //
    int			Read(char *filename);

    //
    // Searching can be done with the Find() member or the array indexing
    // operator
    //
    const String       Find(const char *name) const;
    const String       Find(const char *blockName, const char *name, const char *value) const;
    const String       Find(URL *aUrl, const char *value) const;
    const String       operator[](const char *name) const;
    int		Value(char *name, int default_value = 0) const;
    double	Double(char *name, double default_value = 0);
    int		Boolean(char *name, int default_value = 0) const;
    int		Value(char *blockName,char *name,char *value,int default_value = 0);
    double	Double(char *blockName,char *name,char *value,double default_value = 0);
    int		Boolean(char *blockName,char *name,char *value,int default_value = 0);
    int		Value(URL *aUrl,char *value,int default_value = 0);
    double	Double(URL *aUrl,char *value,double default_value = 0);
    int		Boolean(URL *aUrl,char *value,int default_value = 0);
    Object     *Get_Object(char *name);

    //
    // Read defaults from an array
    //
    void		Defaults(ConfigDefaults *);

protected:
    Dictionary		dcGlobalVars;
    Dictionary          dcServers;
    Dictionary          dcUrls;
    String		*separators;
    int			allow_multiple;
};


#endif
