//
// Collection.cc
//
//
#if RELEASE
#endif

#include "htsearch.h"
#include "Collection.h"
#include "ResultMatch.h"
#include "WeightWord.h"
#include "StringMatch.h"
#include "QuotedStringList.h"
#include "URL.h"
#include <fstream.h>
#include <stdio.h>
#include <ctype.h>
#include <syslog.h>
#include <locale.h>
#include "HtURLCodec.h"
#include "HtWordType.h"

//*****************************************************************************
//
Collection::Collection(char *name, char *word_file, char *index_file, 
    char *doc_file)
{
    isopen = 0;
    collectionName = name;
    wordFile = word_file;
    indexFile = index_file;
    docFile = doc_file;
    docIndex = NULL;
    matches = NULL;
    searchWords = NULL;
    searchWordsPattern = NULL;
}

Collection::~Collection()
{
    Close();
}

void
Collection::Open()
{
    if (!isopen)
    {
        docIndex = Database::getDatabaseInstance();
        docIndex->OpenRead(indexFile);
        docDB.SetCompatibility(config.Boolean("uncoded_db_compatible", 1));
        docDB.Read(docFile);
    }
    isopen = 1;
}

void
Collection::Close()
{
    if (isopen)
    {
        docDB.Close();
        docIndex->Close();
        docIndex = NULL;
    }
    isopen = 0;
}

// Collection::operator [] (char *u) 

DocumentRef *
Collection::getDocumentRef(char *u)
{
    Open();
    return docDB[u];
}

int
Collection::Get(char *key, String &data)
{
    Open();
    return docIndex->Get(key, data);
}


