// DocMatch.cc
//
// DocMatch: Data object only. Contains information related to a given
//           document that was matched by a search. For instance, the
//           score of the document for this search.
//           
// Part of the ht://Dig package   <http://www.htdig.org/>
// Copyright (c) 1999 The ht://Dig Group
// For copyright details, see the file COPYING in your distribution
// or the GNU Public License version 2 or later
// <http://www.gnu.org/copyleft/gpl.html>
//
// $Id: DocMatch.cc,v 1.3.2.1 2000/02/27 04:34:56 ghutchis Exp $
//

#include "DocMatch.h"


//*******************************************************************************
// DocMatch::DocMatch()
//


//*******************************************************************************
// DocMatch::~DocMatch()
//
DocMatch::~DocMatch()
{
}

void
DocMatch::Merge(const DocMatch &match)
{
        if(match.anchor < anchor)
        {
		anchor = match.anchor;
        }
        AddLocations(match.GetLocations());
}

void
DocMatch::AddLocations(const List *locs)
{
	List *merge = new List;
	ListCursor c;

	locations->Start_Get();
	locs->Start_Get(c);
	Location *a = (Location *)locations->Get_Next();
	Location *b = (Location *)locs->Get_Next(c);
	while(a && b)
	{
		if(a->from <= b->from)
		{
			merge->Add(a);
			a = (Location *)locations->Get_Next();
		}
		else // (a->from > b->from)
		{
			merge->Add(new Location(*b));
			b = (Location *)locs->Get_Next(c);
		}
	}
	while(a)
	{
		merge->Add(a);
		a = (Location *)locations->Get_Next();
	}
	while(b)
	{
		merge->Add(new Location(*b));
		b = (Location *)locs->Get_Next(c);
	}
	locations->Release();
	delete locations;
	locations = merge;
}

void
DocMatch::SetLocations(List *locs)
{
	delete locations;
	locations = locs;
}

DocMatch::DocMatch(const DocMatch &other)
{
	score = -1.0;
	//score = other.score;
	id = other.id;
	anchor = other.anchor;
	locations = new List;
	AddLocations(other.GetLocations());
}

void
DocMatch::SetWeight(double weight)
{
	locations->Start_Get();
	for(int i = 0; i < locations->Count(); i++)
	{
		Location *loc = (Location *)locations->Get_Next();
		loc->weight = weight;
	}
}


void
DocMatch::Dump()
{
	cout << "DocMatch id: " <<  id << endl;
	locations->Start_Get();
	for(int i = 0; i < locations->Count(); i++)
	{
		Location *loc = (Location *)locations->Get_Next();
		cout << "location [" << loc->from;
		cout << ", " << loc->to << "] ";
		cout << "weight " << loc->weight;
		cout << " flags " << loc->flags;
		cout << endl;
	}
}
