//
// DocMatch.h
//
// DocMatch: Data object only. Contains information related to a given
//           document that was matched by a search. For instance, the
//           score of the document for this search.
//           
// Part of the ht://Dig package   <http://www.htdig.org/>
// Copyright (c) 1999 The ht://Dig Group
// For copyright details, see the file COPYING in your distribution
// or the GNU Public License version 2 or later
// <http://www.gnu.org/copyleft/gpl.html>
//
// $Id: DocMatch.h,v 1.4.2.1 2000/02/27 04:34:56 ghutchis Exp $
//

#ifndef _DocMatch_h_
#define _DocMatch_h_

#ifdef HAVE_CONFIG_H
#include "htconfig.h"
#endif

#include "Object.h"
#include "List.h"

class Collection;

struct Location : public Object
{
	Location(int f, int t, unsigned int l, double w = 1.0) :
		from(f), to(t), flags(l), weight(w) {}
	Location(const Location &l) :
		from(l.from), to(l.to), flags(l.flags), weight(l.weight) {}
	int from;
	int to;
	unsigned int flags;
	double weight;
};

class DocMatch : public Object
{
public:
	DocMatch() :
		locations(new List),
		score(0.0),
		id(0),
		anchor(0),
		collection(0) {}
		
	DocMatch(const DocMatch &);
	~DocMatch();

	void Merge(const DocMatch &);

	double GetScore() const;
	void SetScore(double);

	int GetId() const { return id; }
	void SetId(int x) { id = x; }

	int GetAnchor() const { return anchor; }
	void SetAnchor(int x) { anchor = x; }

	const List *GetLocations() const { return locations; }
	void SetLocations(List *);
	void AddLocations(const List *);
	void AddLocation(Location *x) { locations->Add(x); }

	void SetWeight(double weight);

	void Dump();
	

//private:

	List			*locations;
	double				score;
	int				id;
	int				anchor;
	Collection                      *collection; // Multiple databases
};

#endif


