package HTML::FormFu::Element::Composed;

use strict;
use base qw/ HTML::FormFu::Element::_Field HTML::FormFu::Element::Multi/;
use Carp qw/ croak /;

__PACKAGE__->mk_accessors(
    qw/
        default_natural original_params
        /
);

sub get_elements {
    return HTML::FormFu::Element::Block::get_elements( @_ )
}



sub nested_name {
    my $self = shift;

    croak 'cannot set nested_name' if @_;

    return if !defined $self->name;

    my @names = $self->nested_names;

    if ( $self->form->nested_subscript ) {
        my $name = shift @names;
        map { $name .= "[$_]" } @names;
        return $name;
    }
    else {
        return join ".", @names;
    }
}

sub nested_names {
    my $self = shift;
    croak 'cannot set nested_names' if @_;

    if ( defined $self->name ) {
        my @names;
        my $parent = $self;

        while ( defined $parent->parent ) {
            $parent = $parent->parent;

            push @names, $parent->nested_name
                if defined $parent->nested_name;
        }

        if (@names) {
            return reverse(@names), $self->name;
        }
    }

    return ( $self->name );
}

sub new {
    my $self = shift->next::method(@_); 
    $self->is_field(0);
    return $self;
}

sub process_input {
    my ( $self, $input ) = @_;

    my $fields = $self->HTML::FormFu::ObjectUtil::get_nested_hash_value( $input, $self->nested_name );
    $self->original_params( $fields );
    my $result = $self->next::method($input);
    return $result;
}

sub get_fields {
    my $self = shift;
    my %args = HTML::FormFu::Util::_parse_args(@_);

    my $f = $self->HTML::FormFu::Element::Block::get_fields;

    unshift @$f, $self;

    return HTML::FormFu::Util::_get_elements( \%args, $f );
}

sub params_for_render {
    my $self = shift;
    return $self->original_params if $self->original_params;
    my %params;
    my $dt = $self->value();
    warn 'value: ' . $dt;
    if( $dt ){
        for my $field ( @{$self->get_elements} ) {
            next if ! $field->is_field;
            my $name = $field->name;
            $params{$name} = $dt->$name;
        }
    }
    return \%params;
}


sub string {
    my ( $self, $args ) = @_;
    $args ||= {};

    my $render
        = exists $args->{render_data}
        ? $args->{render_data}
        : $self->render_data_non_recursive;

    # field wrapper template - start

    my $html = $self->_string_field_start($render);

    # multi template

    $html .= sprintf "<span%s>\n", HTML::FormFu::Util::process_attrs( $render->{attributes} );
    my ( $pm_field ) = @{ $self->get_fields( { name => 'pm' } ) };
    for my $field ( @{ $self->get_fields } ){
        next if not $self->value;
        my $name = $field->name;
        next if $name eq $self->name or $name eq 'pm';
        my $value = $self->value->$name;
        if( defined $pm_field and $name eq 'hour' ){
            if ( $value > 11 ){
                $value -= 12;
                $pm_field->default(1);
                $pm_field->value(1);
            }
        }
        $field->default( $value );
        $field->value( $value );
    }
    for my $elem ( @{ $self->get_elements } ) {
        my $elem_html = $elem->render;

        # skip Blank fields
        if ( length $elem_html ) {
            $html .= $elem_html . "\n";
        }
    }

    $html .= "</span>";

    # field wrapper template - end

    $html .= $self->_string_field_end($render);

    return $html;
}


1;
