package HTML::FormFu::Element::SelectMonth;
use strict;
use base 'HTML::FormFu::Element::Select';
use Carp qw/ croak /;
use DateTime::Locale;

sub months {
    my ($self, $arg) = @_;
    my @prefix = map { [ '', $_ ] }
        ref $arg->{prefix} ? @{ $arg->{prefix} } : 
        $arg->{prefix} ? $arg->{prefix} : ();


    my @months = defined $arg->{names} ? @{ $arg->{names} } : _build_month_list($self, $arg);

    $self->options( [ @prefix, map { [ $_ + 1, $months[$_] ] } 0 .. 11 ]);
    return;
}

sub _build_month_list {
    my ($self, $arg) = @_;
    my @months;

        for my $lang ( @{ $self->form->languages } ) {
            my $loc;
            eval { $loc = DateTime::Locale->load($lang); };
            if ( !$@ ) {
                @months
                    = map {ucfirst}
                    $arg->{short_names}
                    ? @{ $loc->month_abbreviations }
                    : @{ $loc->month_names };

                last;
            }
        }

    return @months;
}

sub _render_container_class {
    my ( $self, $render ) = @_;

    HTML::FormFu::Util::append_xml_attribute( $render->{container_attributes}, 'class', 'select' );

    return;
}

1;

