package HTML::FormFu::Element::SelectYear;

use strict;
use base 'HTML::FormFu::Element::Select';
use Carp qw/ croak /;


sub years {
    my ( $self, $arg ) = @_;
    my @prefix = map { [ '', $_ ] }
        ref $arg->{prefix} ? @{ $arg->{prefix} } : 
        $arg->{prefix} ? $arg->{prefix} : ();

    my $year_ref = defined $arg->{reference} ? $arg->{reference} : ( localtime(time) )[5] + 1900;
    my @years = defined $arg->{list}
    ? @{ $arg->{list} }
    : ( $year_ref - $arg->{less} ) .. ( $year_ref + $arg->{plus} );

    $self->options( [ @prefix, map { [ $_, $_ ] } @years ] );
}

sub _render_container_class {
    my ( $self, $render ) = @_;

    HTML::FormFu::Util::append_xml_attribute( $render->{container_attributes}, 'class', 'select' );

    return;
}

1;


