package HTML::FormFu::Inflator::ComposedDate;

use strict;
use base 'HTML::FormFu::Inflator';
use Class::C3;

use DateTime;

sub inflator {
    my ( $self, $value ) = @_;

    return unless defined $value && $value ne "";
    my %values = %{$value};
    $values{hour} = $values{hour} + 12 if $values{pm};
    delete $values{pm};
    my $dt = DateTime->new( \%values );
    return $dt;
}


1;

__END__

=head1 NAME

HTML::FormFu::Inflator::ComposedDate - ComposedDate inflator

=head1 SYNOPSIS

    ---
    elements:
      - type: Text
        name: start_date
        inflators:
          - type: ComposedDate
     
      - type: Text
        name: end_time
        inflators:
          - type: ComposedDate
=head1 DESCRIPTION

Inflate dates into L<DateTime> objects.

=head1 METHODS

=head1 AUTHOR

Zbigniew Lukasiak

=head1 LICENSE

This library is free software, you can redistribute it and/or modify it under
the same terms as Perl itself.

=cut
