use strict;
use warnings;

use Test::More tests => 12;

use HTML::FormFu;
use DateTime;
use lib '../html-formfu/HTML-FormFu-Model-DBIC/t/lib';
use DBICTestLib 'new_db';
use MySchema;

new_db();

my $form = HTML::FormFu->new();
$form->load_config_file('t/datetime.yml');

$form->process( {
        'date_col.day', 6, 'date_col.month', 8, 'date_col.year', 2010, 'date_col.hour' => 8, 'date_col.pm' => '1'
    } );
ok( $form->submitted_and_valid );

my $result_date = $form->param_value('date_col');
ok( ref $result_date eq 'DateTime', 'Date inflated' );
ok( !DateTime->compare( DateTime->new( day => 6, month => 8, year => 2010, hour => 20  ), $form->param_value('date_col') ),
    'Date inflated correctly'); 
warn $form->param_value('date_col');
warn DateTime->new( day => 6, month => 8, year => 2010, hour => 20  );
warn DateTime->compare( DateTime->new( day => 6, month => 8, year => 2010, hour => 20  ), $form->param_value('date_col') );

my $render = $form->render;
like( $render, qr{<option value="2010" selected="selected">2010</option>}, 'Year rendered properly' );

$form->process( {
        'date_col.day', 66, 'date_col.month', 8, 'date_col.year', 2009, 
    } );
ok( $form->has_errors, 'wrong day detected' );


#
# Database tests
#

$form = HTML::FormFu->new();
$form->load_config_file('t/datetime.yml');
$form->process;

my $schema = MySchema->connect('dbi:SQLite:dbname=t/test.db');

my $rs = $schema->resultset('Master');

# filler row

$rs->create( { text_col => 'filler', } );

# row we're going to use

my $id = $rs->create( {
        date_col       => '2009-12-31 20:00:00'
    } )->id;

{   
    my $row = $rs->find( $id );

    $form->model('DBIC')->default_values($row);

    # column is inflated
    my $date = $form->get_field('date_col')->default;

    isa_ok( $date, 'DateTime' );

    is( $date->day,   '31' );
    is( $date->month, '12' );
    is( $date->year,  '2009' );
    my $render = $form->render;
    like( $render, qr{<option value="2009" selected="selected">2009</option>}, 'Year rendered properly' );
    like( $render, qr{<option value="8" selected="selected">8</option>}, 'Hour rendered properly' );

    $form->process( { 
        'date_col.day', 6, 'date_col.month', 8, 'date_col.year', 2010, 
    } );
    $form->model('DBIC')->update($row);

}

my $row = $rs->find( $id );
ok( !DateTime->compare( DateTime->new( day => 6, month => 8, year => 2010  ), $row->date_col ), 'Date saved to DB' );


