-------------------------------------------------------------------------------
-- $Id: AdderTree.hs,v 1.4 2000/01/13 23:51:43 satnam Exp $
-------------------------------------------------------------------------------

module AdderTree (adderTree, regAdderTree)
where
import Lava
import Virtex
import RippleAdder
import Registers

-------------------------------------------------------------------------------

adderTree :: Circuit nsi bit => 
             [TwosComplement bit] -> nsi (TwosComplement bit)
adderTree = tree verticalAdder

-------------------------------------------------------------------------------

adderTree_inputs = [[1,2,3,4,5,6,7,8,9],
                    [1,1,1,1,1,1,1,1,1],
                    [2,2,2,2,2,2,2,2,2]]

-- Expected output: [45,9,18]

adderTree_sim1 
  = stream2int (adderTree (map (intStream 8) (transpose adderTree_inputs)))


adder_tree_sim1_top
  = do inputs <- sequence [inputVec ("a"++ show i) (bit_vector 7 downto 0) | i <- [1..8]]
       r <- adderTree inputs
       outputVec r "sum" (bit_vector 10 downto 0)


-------------------------------------------------------------------------------


regAdderTree :: Circuit nsi bit => 
                [TwosComplement bit] -> nsi (TwosComplement bit)
regAdderTree = pipeTree register verticalAdder 

adder_tree_reg_top
  = do inputs <- sequence [inputVec ("a"++ show i) (bit_vector 7 downto 0) | i <- [1..9]]
       clk <- globalClock "clk"
       clr <- globalClear "clr"
       r <- regAdderTree inputs
       outputVec r "sum" (bit_vector 10 downto 0)



adder_tree8v = circuit2VHDL "adder_tree8" adder_tree_reg_top        


-------------------------------------------------------------------------------

regAdderTree_inputs = [[1,2,3,4,5,6,7,8,9],
                       [1,1,1,1,1,1,1,1,1],
                       [2,2,2,2,2,2,2,2,2],
                       [3,3,3,3,3,3,3,3,3],
                       [4,4,4,4,4,4,4,4,4]]

regAdderTree_sim1 
  = stream2int (regAdderTree (map (intStream 8) 
               (transpose regAdderTree_inputs)))

-------------------------------------------------------------------------------
  