-------------------------------------------------------------------------------
-- $Id: BitVec.hs,v 1.6 2000/01/07 16:01:39 satnamxdc Exp $
-------------------------------------------------------------------------------

module BitVec
where


bools2int :: Integral num => [Bool] -> num              
bools2int bv = sum [i*2^n | (i,n) <- zip (map bool2int bv) [0..]]

bool2int False = 0
bool2int True = 1

int2bitvec :: Integral num => Int -> num -> [Bool]
int2bitvec size n = int2bitvec' size n

int2bitvec' :: Integral num => Int -> num -> [Bool]
int2bitvec' 0 i = []
int2bitvec' size n 
  = (if n `mod` 2 == 0 then
       False
     else
       True) : int2bitvec' (size-1) (n `div` 2)
       
addBits bv1 bv2
  = --trace ("addBits " ++ show (bools2int bv1) ++ " " ++ show (bools2int bv2)
    --        ++ " = " ++ show (bools2int result) ++ "\n")
    result
    where
    result = int2bitvec' size (bools2int bv1 + bools2int bv2) 
    size = max (length bv1) (length bv2)

       
showBoolBit False = '0'
showBoolBit True = '1'

showBoolBits = map showBoolBit

showBoolBitsList = show . map showBoolBits 