-------------------------------------------------------------------------------
-- $Id: Gates.hs,v 1.6 2000/01/20 18:24:31 satnam Exp $
-------------------------------------------------------------------------------

module Gates
where

import TypeExpr

-------------------------------------------------------------------------------

data Cell
  = Unused | Vcc | Gnd | Ibuf | Obuf | Bufgp | Buf
  | Lut1 Int | Lut2 Int | Lut3 Int | Lut4 Int
  | Rom16x1 Int | Muxcy | Xorcy | Fd | Fdc | Obuf_S_2 | M2_1 
  | MuxF5 | MuxF5_L | MuxF6 | MuxF6_L
    deriving (Eq, Show)

-------------------------------------------------------------------------------

showCell cell
  = case cell of
      Vcc -> "vcc"
      Gnd -> "gnd"
      Ibuf -> "ibuf"
      Obuf -> "obuf"
      Obuf_S_2 -> "obuf_s_2"
      Bufgp -> "bufgp"
      Buf -> "buf"
      Lut1 _ -> "lut1"
      Lut2 _ -> "lut2"
      Lut3 _ -> "lut3"
      Lut4 _ -> "lut4"
      Rom16x1 _ -> "rom16x1"
      Muxcy -> "muxcy"
      Xorcy -> "xorcy"
      Fd -> "fd"
      Fdc -> "fdc"
      M2_1 -> "m2_1"
      MuxF5 -> "muxf5"
      MuxF5_L -> "muxf5_l"
      MuxF6 -> "muxf6"
      MuxF6_L -> "muxf6_l"
      Unused -> "<unused>"
      other -> error ("showCell: " ++ show other)

-------------------------------------------------------------------------------
