-------------------------------------------------------------------------------
-- $Id: HexUtils.hs,v 1.3 2000/01/20 18:24:31 satnam Exp $
-------------------------------------------------------------------------------


module HexUtils
where
import BitOps
import List
import Utils
import Char


genHexLines :: Integral num => [num] -> [String]
genHexLines ram
  = hex
    where
    inits = chop 16 ram
    hex  = [concat $ reverse ((map (wrHex 2)) l) | l <- inits]


wrHex :: Integral n => Int -> n -> String
wrHex size
  = concat . reverse . map showHexByte . (hexParts size)

-------------------------------------------------------------------------------

-- This function takes a number and returns a list of numbers
-- that represents each hex digit of that number, staring with
-- the least significant hex-digit.


hexParts :: Integral num => Int -> num -> [num]
hexParts 0 0 = []
hexParts 0 others = error ("hexParts size too small: " ++ show others)
hexParts size n = (n `mod` 0x100) : 
                  hexParts (size-1) (n `div` 0x100)

-------------------------------------------------------------------------------


showHexByte :: Integral num => num -> String
showHexByte n 
  = showHexDigit (n `div` 0x10) ++ showHexDigit (n `mod` 0x10)

showHexDigit :: Integral num => num -> String
showHexDigit d
  = if d <= 9 then
      show d
    else
      [['A'..'F']!!(fromIntegral d-10)]

genInits ram
  = ["    INIT_" ++ (wrHex 1 i) ++ " => X\"" ++ hexlines!!(fromInteger i) ++ "\"" ++ condcomma i | i <- [0..15]]
    where
    hexlines = genHexLines ram
    condcomma i = if i == 15 then "" else ","

showBitsAsHex bits
  = concat [showHexDigit (bv2i (reverse b)) |  b <- chop 4 bits]


   

readh "" = 0
readh (x:xs) = hexchr x + 16 * readh xs

hexchr x
  = case toLower x of
      '0' -> 0
      '1' -> 1
      '2' -> 2
      '3' -> 3
      '4' -> 4
      '5' -> 5
      '6' -> 6
      '7' -> 7
      '8' -> 8
      '9' -> 9
      'a' -> 10
      'b' -> 11
      'c' -> 12
      'd' -> 13
      'e' -> 14
      'f' -> 15 
      
string2hex str = readh (reverse str)        

hexstr2signed :: (Integral a, Num a) => a -> String -> a
hexstr2signed s str
  = signed s n
    where
    n = string2hex str

    
signed n v
  = if v >= 2^(n-1) then
      -(2^(n-1)) + u
    else
      v
    where  
    u = v `mod` 2^(n-1)  
    
h2i :: Int -> String -> Int
h2i = hexstr2signed   