module Main
where

import Lava
import Virtex
import VirtexLib
import SplitMultiplier
import TestSplitMultiplier
import System
import KCMUtils      

main = do args <- getArgs
          kcm_main args

kcm_main ["-regtest"] = splitMultiplierRegressionTests
kcm_main ["-v"] = showVersion
kcm_main ["-version"] = showVersion
kcm_main ["-h"] = usage
kcm_main ["-help"] = usage
kcm_main args@(x:xs) | x /= "-comb" && x/= "-pipe" 
  = kcm_main (("-pipe"):args)
kcm_main [comb, coief_value_str, sign_str, input_size_str]
  = do putStrLn ("LavaCORE KCM Generator [" ++ version ++ "]")
       putStrLn ("Coefficient: " ++ show coief ++ " (" ++
                 show coief_size ++ "-bits)")
       putStrLn ("Data       : " ++ show data_size ++ "-bits " ++
                 tail (sign_str))
       putStrLn latnecyStr
       circuit2VHDL filename netCir
       putStrLn "Done."
    where
    netCir :: StateST state ()
    netCir = circuit dataSigned coief coief_size data_size
    pipelined = comb /= "-comb"
    circuit = if pipelined then
                kcm_top
              else
                comb_kcm_top
    dataSigned = if sign_str == "-unsigned" then
                   False
                 else
                  if sign_str == "-signed" then
                    True
                 else
                   error ("Sign should be either -sign or -unsigned.\n")
    coief :: Integer 
    coief = read coief_value_str
    coief_size :: Int
    coief_size = bitsrequired coief
    data_size :: Int
    data_size = read input_size_str
    filename = "kcm_" ++ showK coief ++ showSign (coief < 0) ++ "_" ++
                show data_size ++ showSign dataSigned
    showK n = if n < 0 then
               "minus_" ++ show (abs n)
              else
                show n
    showSign signed = if signed then
                        "s"
                      else
                        "u"
    latnecyStr
      = if pipelined then
          "Latency    : " ++ show (latency data_size) ++ " ticks"
        else
          "Combinational"


kcm_main other = usage

usage
  = putStrLn ("Usage: kcm [-comb | -pipe] coeif [-unsigned | -signed] data_size")

-------------------------------------------------------------------------------


kcm1 = kcm_main ["2047", "-unsigned", "12"]
kcm2 = kcm_main ["2047", "-unsigned", "4"]
kcm3 = kcm_main ["2047", "-unsigned", "6"]
kcm4 = kcm_main ["-comb", "2047", "-unsigned", "6"]
kcm5 = kcm_main ["-comb", "2047", "-unsigned", "32"]

-------------------------------------------------------------------------------

version = "LavaCORE KCM Beta A 24 January 2000"

-------------------------------------------------------------------------------

showVersion
  = putStrLn ("kcm version " ++ version)

-------------------------------------------------------------------------------

