-------------------------------------------------------------------------------
-- $Id: LUTROM.hs,v 1.4 2000/01/20 18:24:31 satnam Exp $
-------------------------------------------------------------------------------

module LUTROM (rom16x, rom32x1, rom32x, lutrom_tests)
where
import Lava
import Virtex
import BitOps

-------------------------------------------------------------------------------

-- This circuit uses multiple ROM16X1 components to make a ROM16XN component.
-- It need a function to tell it how to convert the the list of numbers
-- into a bit-vector.

rom16x :: (Integral num, Circuit nsi bit) =>
          Int -> [num] -> [bit] -> nsi [bit]
rom16x _ contents _ | length contents > 16
  = error ("rom16x can't take a list longer than 16: " ++ show contents 
           ++ " has length " ++ show (length contents) ++ "\n")
rom16x n contents addr@[a0,a1,a2,a3]
  = par [rom16x1 c | c <- rom_data]
        (replicate n addr)
    where
    -- Pad the contents
    contents' = pad_with 0 16 contents
    -- Compute the ROM data.
    rom_data = transpose (map (i2bv n) contents')
rom16x _ _ addr
  = error ("rom16x requires a four-bit address: " ++ show addr ++ "\n")


-------------------------------------------------------------------------------

-- An example use of rom16x.

rom16x_eg1_input :: [Int]
rom16x_eg1_input = [7, 2, 8, 4, 3, 11, 22, 1, 5, 6, 9, 10, 12, 13, 14, 15]

rom16x_eg1 :: Circuit nsi bit => [bit] -> nsi [bit]
rom16x_eg1 = rom16x 5 rom16x_eg1_input

rom16x_eg1_sim1 :: [Int]
rom16x_eg1_sim1 = stream2int (rom16x_eg1 (intStream 4 [0..15]))



rom16x_eg2_input :: [Int]
rom16x_eg2_input = [7, 2, 8, 4, 3, 11, 22, 1]

rom16x_eg2 :: Circuit nsi bit => [bit] -> nsi [bit]
rom16x_eg2 = rom16x 5 rom16x_eg2_input

rom16x_eg2_sim1 :: [Int]
rom16x_eg2_sim1 
  = take (length rom16x_eg2_input) 
         (stream2int (rom16x_eg2 (intStream 4 [0..15])))

-------------------------------------------------------------------------------

lutrom_tests
  = do checkResult "rom16x_eg1_test1" rom16x_eg1_input rom16x_eg1_sim1
       checkResult "rom16x_eg1_test2" rom16x_eg2_input rom16x_eg2_sim1   

-------------------------------------------------------------------------------

-- This circuit uses multiple ROM32X1 components to make a ROM32XN component.
-- It need a function to tell it how to convert the the list of numbers
-- into a bit-vector.

rom32x :: (Integral num, Circuit nsi bit) =>
          Int -> [num] -> [bit] -> nsi [bit]
rom32x _ contents _ | length contents > 32
  = error ("rom32x can't take a list longer than 32: " ++ show contents 
           ++ " has length " ++ show (length contents) ++ "\n")
rom32x n contents addr@[a0,a1,a2,a3,a4]
  = par [rom32x1 c | c <- rom_data]
        (replicate n addr)
    where
    -- Pad the contents
    contents' = pad_with 0 32 contents
    -- Compute the ROM data.
    rom_data = transpose (map (i2bv n) contents')
rom32x _ _ addr
  = error ("rom16x requires a four-bit address: " ++ show addr ++ "\n")

-------------------------------------------------------------------------------

rom32x1 :: Circuit nsi bit => [Bool] -> [bit] -> nsi bit
rom32x1 contents addr | length addr /= 5
  = error ("rom32x1: requires 5-bit address but was given a " ++ 
           show (length addr) ++ " address\n")
rom32x1 bits addr
  = do (lower, upper) <- par2 (rom16x1 (take 16 bits'))
                              (rom16x1 (drop 16 bits'))
                               
                              (init addr, init addr)
       result <- muxf5_l (last addr, (lower,upper))
       return result
    where
    bits' = pad_with 0 32 bits  

-------------------------------------------------------------------------------
