-------------------------------------------------------------------------------
-- $Id: Registers.hs,v 1.3 2000/01/20 18:24:32 satnam Exp $
-------------------------------------------------------------------------------

module Registers
where
import Lava
import Virtex

-------------------------------------------------------------------------------

register :: Circuit nsi bit => [bit] -> nsi [bit]
register input = par (replicate (length input) (delayBit False)) input

-------------------------------------------------------------------------------

pitchedRegister :: Circuit nsi bit => Int -> [bit] -> nsi [bit]
pitchedRegister pitch input 
  = par (replicate (length input) (pitchedDelay 1 pitch)) input

-------------------------------------------------------------------------------

pitchedDelay :: Circuit nsi bit => Int -> Int -> bit -> nsi bit
pitchedDelay width height input
  = do addSpace width height
       delayBit False input

-------------------------------------------------------------------------------

