-------------------------------------------------------------------------------
-- $Id: Combinators.hs,v 1.21 2000/01/15 01:02:31 satnam Exp $
-------------------------------------------------------------------------------

module TreeLayoutExperiments
where
import Lava
import Virtex
import VirtexLib
import AdderTree

-------------------------------------------------------------------------------

tree_layout_experiments
  = do circuit2VHDL "adder_tree_96_9" (adder_tree_top 96 9)

-------------------------------------------------------------------------------
-- Adder Trees with bit-growth
-------------------------------------------------------------------------------

adder_tree_top nrInputs inputSize
  = do n <- inputVec "n" (bit_vector (inputSize-1) downto 0)
       clk <- globalClock "clk"
       summation <- regAdderTree (replicate nrInputs n)
       outputVec summation "summation"
          (bit_vector (inputSize+growth-1) downto 0)
     where
     growth = log2 nrInputs


-------------------------------------------------------------------------------

