-------------------------------------------------------------------------------
-- $Id: TypeExpr.hs,v 1.10 2000/01/20 18:24:32 satnam Exp $
-------------------------------------------------------------------------------

module TypeExpr
where

data SignalA a
  = UndefinedVar
  | Var a
  | ArrayElement TypeExpr (SignalA a) Int
  | LavaSig Int
    deriving (Eq, Show)
    
type BitSignal = SignalA String
type Clock = BitSignal      

data TypeExpr
  = BitType
  | BitVector Int Direction Int
    deriving (Eq, Show)
    
data Direction
  = To | Downto
    deriving (Eq, Show)
    
data PortMap = PortMap Mode String (SignalA String)
               deriving (Eq, Show)    

data Port = Port Mode String TypeExpr
            deriving (Eq, Show) 

portmap2port = map portmap2port'

portmap2port' (PortMap mode name v)
  = Port mode name BitType

bit = BitType
    
to = To
downto = Downto    
bit_vector = BitVector  


bitVecIndices a To b = [a..b]
bitVecIndices a Downto b = reverse [b..a]      

showSignal s
  = case s of
      Var a -> a
      ArrayElement t v n -> (showSignal v) ++ "[" ++ show n ++ "]"
      LavaSig n -> "#" ++ show n
      UndefinedVar -> "<undefined>"
      
      
vec :: String -> Int -> [SignalA String]
vec a n = [Var (a++show i) | i <- [0..n-1]]

data Mode = Input | Output
            deriving (Eq, Show)