-------------------------------------------------------------------------------
-- $Id: Verilog.hs,v 1.1 2000/01/23 03:30:16 satnam Exp $
-------------------------------------------------------------------------------

module Verilog (circuit2Verilog)
where
import Lava
import VirtexNetlist
import Array
import IOExts

-------------------------------------------------------------------------------

circuit2Verilog :: String -> NetList -> IO ()  
circuit2Verilog name tuples@(instCount, netCount, intf',
                          (clk,clr,zero,one), instances) 
  = do putStr ("Generating Verilog " ++ filename ++ "...")
       -- showNetListToFile name circuit
       writeFile filename (unlines (verilogEntity name intf))
       verilogArchitecture filename name instCount netCount instances 
       putStrLn ""
    where
    filename = name ++ ".v"
    intf = reverse intf' 

-------------------------------------------------------------------------------

verilogEntity name intf
  = ("module " ++ name ++ " (" ++ insertString "," portNames ++ ") ;") :
     verilogPorts intf
    where
    portNames = [name | Port dir name typ  <- intf]  
     
-------------------------------------------------------------------------------

verilogPorts intf
  = map verilogPort intf 
  
verilogPort (Port dir name typ)
  = showVerilogMode dir ++ " " ++ showType typ ++ " " ++ name ++ " ;"

showVerilogMode Input  = "input"
showVerilogMode Output = "output"

showType BitType = ""
showType (BitVector a dir b)
  = "[" ++ show a ++ ":" ++ show b ++ "]"
    

-------------------------------------------------------------------------------


verilogArchitecture filename name instCount netCount instances
  = do appendFile filename 
        (unlines
         ["",
          "wire [0:" ++ show (netCount-1) ++ " lava ;",
          ""])
       verilogInstances filename instances instCount 0
       appendFile filename "end architecture lava ;\n"

-------------------------------------------------------------------------------

verilogInstances filename instances nrInst i | nrInst == i
  = return ()
verilogInstances filename instances nrInst i
  = do appendFile filename ((verilogInstance i (instances!i) ++ "\n"))
       verilogInstances filename instances nrInst (i+1) 

-------------------------------------------------------------------------------

verilogInstance i (Unused, _, _, _) = ""
verilogInstance i (cell, pos, prop, ports)
  = "  " ++ showCell cell ++ "_" ++ show i ++ " : " ++ showCell cell ++
    verilogGenerics prop ++
    " port map (" ++ insertString ", " (verilogArgs ports) ++ ") ;"

-------------------------------------------------------------------------------

verilogArgs = map verilogArg
 
-------------------------------------------------------------------------------

verilogArg (PortMap dir arg par)
  = arg ++ " => " ++ verilogSignal par

-------------------------------------------------------------------------------

verilogSignal (Var v) = v
verilogSignal (LavaSig n) = "lava(" ++ show n ++ ")"
verilogSignal (ArrayElement typ name idx) = (verilogSignal name) ++ "(" ++ show idx ++ ")" 
verilogSignal UndefinedVar = notrace ("Warning: undefined variable.\n") "UndefinedVar"
verilogSignal other = error ("verilogSignal: " ++ show other)

-------------------------------------------------------------------------------

verilogGenerics [] = []
verilogGenerics xs
  = " generic map (" ++ insertString ", " (map verilogGeneric xs) ++ ")"

-------------------------------------------------------------------------------

verilogGeneric (InitialBV s iv)
  = "init => \"" ++ showBV (reverse (i2bv s iv)) ++ "\""
verilogGeneric other = ""

-------------------------------------------------------------------------------
             
