-------------------------------------------------------------------------------
-- $Id: VirtexGates.hs,v 1.2 2000/01/13 23:51:44 satnam Exp $
-------------------------------------------------------------------------------

module VirtexGates
where
import Lava

-- This module defines some of the Xilinx Unified Library
-- components.

-------------------------------------------------------------------------------

inv :: Combinational nsi bit => bit -> nsi bit
inv  = gate1 not

-------------------------------------------------------------------------------

and2 :: Combinational nsi bit => (bit, bit)
        -> nsi bit
and2 = gate2 (&&)

-------------------------------------------------------------------------------

or2 :: Combinational nsi bit => (bit, bit) -> nsi bit
or2  = gate2 (||) 

-------------------------------------------------------------------------------

xor2 :: Combinational nsi bit => (bit, bit) -> nsi bit
xor2  = gate2 (exor) 

-------------------------------------------------------------------------------

exor :: Bool -> Bool -> Bool
exor a b = a /= b

-------------------------------------------------------------------------------


