#include "automata0.h"

void projExterna(igraph_t g, Automata autom){ 
//TODO - corrigir
    igraph_vector_init(&(autom->momenta->proj_externa), 0);
    int l = igraph_vector_size(&(autom->momenta->proj_externa));
    
    for(int j = 0; j < l; j++){

        if( (int) VAN(&g, "proj_externa", j) == 1 )
        igraph_vector_push_back(&(autom->momenta->proj_externa), j);

    }

}

double densidade(igraph_t g, Automata autom){
    double atv_contagem = (double) igraph_vector_size(&(autom->momenta->em_atividade));
    return atv_contagem/( (double) autom->N);
}

//#TODO declarar/definir pmax na funcao abaixo
struct Automata *criarAutomata(igraph_t g, int num_estados, const int simulation_time, double porcent_inib, double pmax, double fator_proj_externa, igraph_vector_int_t inicialmente_ativados, igraph_vector_t proj_externa, int seed){
    struct Automata *autom = malloc(sizeof(struct Automata));

    autom->momenta = malloc(sizeof(atividade)); 
    autom->N = igraph_vcount(&g);
    autom->num_estados = num_estados;  
    igraph_vector_init(&(autom->densidade), simulation_time);
    igraph_adjlist_init(&g, &(autom->lista_de_adjacencia), IGRAPH_OUT);
    gerarPercept(g, porcent_inib, fator_proj_externa, autom->N, inicialmente_ativados, proj_externa, autom->momenta);
    projExterna(g, autom);
    criarPesos(g, pmax, seed);
    //printf("%f \n",VECTOR(autom->densidade)[0]);  // teste densidade inicial

    return autom;
}

// TODO- completar o destruir automata
void destruirAutomata(struct Automata *autom){

    if(autom){
        if(&(autom->densidade)) igraph_vector_destroy(&(autom->densidade));
        if(&(autom->lista_de_adjacencia)) igraph_adjlist_destroy(&(autom->lista_de_adjacencia));
    }
}

int compara(char *s, char *t){
 
    for ( ; (*s == *t) ; s++, t++)
	if (*s == '\0')
            return 0;
    return *s - *t;
}

void criarPesos(igraph_t g, double pmax, int seed){   

    GRand *rgen = g_rand_new_with_seed(seed);
    double el;

    for(int i = 0; i < igraph_ecount(&g); i++){

       el = (double) g_rand_double_range(rgen, 0.0, pmax);
       SETEAN(&g, "peso", i, el);

    }

}

//** Atualiza nos vizinhos de nos em atividade com probabilidade de entrar em atividade, lista todos os nos atualizados em podem_entrar_em_atividade **//
void probabilidades(igraph_t g, Automata autom){

    int num_ativos = igraph_vector_size(&(autom->momenta->em_atividade));
    int num_vizinhos;
    int viz;
    int ativo;
    double prob;
    double fator_pe = (double) GAN(&g, "fator_proj_externa");
    igraph_vector_int_t *vizinhos;
    igraph_real_t indice;

    for(int i = 0; i < num_ativos; i++){
        
        ativo =  VECTOR(autom->momenta->em_atividade)[i];
        vizinhos = igraph_adjlist_get(&(autom->lista_de_adjacencia), ativo);
        num_vizinhos = (int) igraph_vector_int_size(vizinhos);
        printf("ativo %d\n", (int) ativo);

        for(int j = 0; j < num_vizinhos; j++){
                         
            viz = VECTOR(*vizinhos)[j];
            printf("Seg Falt %d, %d, num %d \n", viz, j, num_vizinhos);
            printf("%d \n",(int) retornaEstado(g, viz));

            if( ( (int) retornaEstado(g, viz) == 0) && compara(retornaTipo(g, ativo), "excit") && (int) retornaAtivavel(g, viz) != 0 ){
        
                prob = (double) retornaProb(g, viz);
                printf("prob %f\n", prob);
                SETVAN(&g,"prob_ativar", viz, prob*(1.0- ((double) retornaPeso(g, ativo, viz) ) ) );

              } else if( ( (int) retornaEstado(g, viz) == 0) && compara(retornaTipo(g, ativo), "excit" ) &&  (int) retornaAtivavel(g, viz) == 0 ){

                indice = viz;
                igraph_vector_push_back(&(autom->momenta->primeiros_vizinhos), indice);
//              inserirElemento(autom->percepcao->podem_entrar_em_atividade, &no_vizinho);
                SETVAN(&g, "ativavel", viz, 1);
                printf("0\n");

                if( (int) VAN(&g, "proj_externa", viz) == 1){                    
                    
                    SETVAN(&g,"prob_ativar", viz, fator_pe*(1.0 - ((double) retornaPeso(g, ativo, viz) ) ) );
                    printf("1\n");

                }else{
                       
                    prob = (double) retornaProb(g, viz);
                    printf("prob %f\n", prob);
                    SETVAN(&g,"prob_ativar", viz, prob*(1.0 - ((double) retornaPeso(g, ativo, viz) ) ) );
                    printf("2\n");

                }

            }else if( ( (int) retornaEstado(g, viz) == 0) && compara(retornaTipo(g, ativo), "inib" ) &&  (int) retornaAtivavel(g, viz) != 0 ){

                prob = (double) retornaProb(g, viz);
                printf("prob %f\n", prob);
                SETVAN(&g,"prob_ativar", viz, prob*(1.0- ((double) retornaPeso(g, ativo, viz) ) ) );

            } else if( ( (int) retornaEstado(g, viz) == 0) && compara(retornaTipo(g, ativo), "inib" ) &&  (int) retornaAtivavel(g, viz) == 0 ){

                SETVAN(&g, "ativavel", viz, 1);
                indice = viz;
                igraph_vector_push_back(&(autom->momenta->primeiros_vizinhos), indice);
                printf("00\n");

                if( (int) VAN(&g, "proj_externa", viz) == 1){
                    
                    SETVAN(&g,"prob_ativar", viz, fator_pe*( (double) retornaPeso(g, ativo, viz) ) );
                    printf("11\n");

                }else{
                       
                    prob = (double) retornaProb(g, viz);
                    printf("prob %f\n", prob);
                    SETVAN(&g,"prob_ativar", viz, prob + ( (double) retornaPeso(g, ativo, viz) ) );
                    printf("22\n");

                }

            }

        }
    
    }    

    int t = igraph_vector_size(&(autom->momenta->proj_externa));
    printf("0\n");

    for(int i = 0; i < t; i++ ){
        
        viz = VECTOR(autom->momenta->proj_externa)[i];
        printf("1\n");

        if( ( (int) retornaEstado(g, viz) == 0) &&  ((int) retornaAtivavel(g, viz) != 0) ){

            SETVAN(&g, "prob_ativar", viz, fator_pe );
            SETVAN(&g, "ativavel", viz, 1);
            igraph_vector_push_back(&(autom->momenta->primeiros_vizinhos), viz);
            printf("2\n");

        }
    }

}

//void simular(Automata autom /*, Output io*/){}
/*
   int num_trans, num_ativo, num_refrat;
   int tempo_total = igraph_vector_size(&(autom->densidade));
   GRand *rgen = g_rand_new_with_seed(23132);
   Lista *transicoes = gerarLista();
   double *el;

   for(int t = 0; t < tempo_total; t++){
       VECTOR(autom->densidade)[t] = densidade(autom);
       printf("%f \n",VECTOR(autom->densidade)[t]);  // teste densidade inicial
       probabilidades(autom); // atualiza probabilidades de transicao

       num_trans = autom->percepcao->podem_entrar_em_atividade->contagem;

       for(int j = 0; j < num_trans; j++){
           el = malloc(sizeof(double));
           *el = (double) g_rand_double_range(rgen, 0.0, 1.0);
           copiarElemento(transicoes, el);
       }
          
       num_ativo =  autom->percepcao->em_atividade->contagem;
       Lista_No no_ativo = autom->percepcao->em_atividade->primeiro;
       No_Sinal sinal_ativo = (No_Sinal) no_ativo->valor;

       num_refrat =  autom->percepcao->acabaram_atividade->contagem;
       Lista_No no_refrat = autom->percepcao->acabaram_atividade->primeiro;
       printf("numero de refratorios %d\n",num_refrat);
       int a,j;
       j = 0;

       while( j < num_refrat ){
          
     
           No_Sinal sinal_refrat = (No_Sinal) no_refrat->valor;  
           a = (sinal_refrat->estado + 1) % autom->num_estados;
           printf("despueis %d\n",a);
           sinal_refrat->estado = a;

           if(a == 0){
               no_refrat = retornaProximo(no_refrat);
               apagarElemento(autom->percepcao->acabaram_atividade , j);
               // TODO - Verificar se elemento nao esta sendo apagada de outras Listas em particular da Lista nos, se for apagado sera necessario reinserir com o Lista_No retornado pelo apagarElemento
               num_refrat--;
           }else{
               j++;
               no_refrat = retornaProximo(no_refrat);
           }

       }
  
       j = 0;

       while( j < num_ativo ){
         
           a = (sinal_ativo->estado + 1) % autom->num_estados;
           sinal_ativo->estado = a;
            
           if(a != 0){
               no_ativo = retornaProximo(no_ativo);
               inserirElemento(autom->percepcao->acabaram_atividade, apagarElemento(autom->percepcao->em_atividade , j) );
               num_ativo--;
               // TODO - Verificar se elemento nao esta sendo apagada de outras Listas em particular da Lista nos, se for apagado sera necessario reinserir com o Lista_No retornado pelo apagarElemento
           }else{                  
               no_ativo = retornaProximo(no_ativo);
               apagarElemento(autom->percepcao->em_atividade , j);
               num_ativo--;
           }

       }                       
        
       // TODO - utilizar transicoes e podem_entrar_em_atividade pra fazer selecao de estados que transitam

   }

*/
