#ifndef _Automata_h
#define _Automata_h
#include "perceptlib0.h"

typedef struct Automata{
   
    igraph_vector_t densidade;
    igraph_adjlist_t lista_de_adjacencia;
    atividade momenta;
    int N;
    int num_estados;
    
} *Automata;

struct Automata *criarAutomata(igraph_t g, int num_estados, const int simulation_time, double porcent_inib, double pmax, double fator_proj_externa, igraph_vector_int_t inicialmente_ativados, igraph_vector_t proj_externa, int seed);

void projExterna(igraph_t g, Automata autom);

double densidade(igraph_t g, Automata autom);

void destruirAutomata(Automata autom);

void criarPesos(igraph_t g, double pmax, int seed);

void probabilidades(igraph_t g, Automata autom);

//void simular(Automata autom);

int compara(char *s, char *t);

#endif
