#include "perceptlib0.h"

void gerarSinais(igraph_t g, char *tipo, int estado, int ativavel, int index){

    SETVAS(&g, "tipo", index, tipo);
    SETVAN(&g, "estado", index, estado);
    SETVAN(&g, "ativavel", index, ativavel);    

}

igraph_real_t retornaEstado(igraph_t g, int index){

   if( index >= igraph_vcount(&g) ){
       printf("Indice maior que numero de nos da rede");
       return 0;
   }else{         
       return VAN(&g, "estado", index);
   }
}

igraph_real_t retornaProb(igraph_t g, int index){

   if( index >= igraph_vcount(&g) ){
       printf("Indice maior que numero de nos da rede");
       return 0;
   }else{         
       return VAN(&g, "prob_ativar", index);
   }
}

igraph_real_t retornaAtivavel(igraph_t g, int index){

   if( index >= igraph_vcount(&g) ){
       printf("Indice maior que numero de nos da rede");
       return 0;
   }else{         
       return VAN(&g, "ativavel", index);
   }
}

igraph_real_t retornaProjExterna(igraph_t g, int index){

   if( index >= igraph_vcount(&g) ){
       printf("Indice maior que numero de nos da rede");
       return 0;
   }else{         
       return VAN(&g, "proj_externa", index);
   }
}

const char *retornaTipo(igraph_t g, int index){

   if( index >= igraph_vcount(&g) ){
       printf("Indice maior que numero de nos da rede");
       return 0;
   }else{         
       return VAS(&g, "tipo", index);
   }
}

void gerarPercept(igraph_t g, double porcent_inib, double fator_proj_externa, int num_nodes, igraph_vector_int_t em_atividade_iniciais, igraph_vector_t proj_externa, atividade ativos){

     igraph_vector_init(&(ativos->em_atividade), 0);
     int s = igraph_vector_size(&em_atividade_iniciais);

     for(int j = 0; j < s; j++){
         printf("%d\n",VECTOR(em_atividade_iniciais)[j]);
         igraph_vector_push_back(&(ativos->em_atividade), VECTOR(em_atividade_iniciais)[j]);
     }

     igraph_vector_init(&(ativos->primeiros_vizinhos), 0);
     igraph_real_t fpe = fator_proj_externa;
     SETGAN(&g, "fator_proj_externa", fpe);
     SETGAN(&g, "porcent_inib", porcent_inib);
     SETGAN(&g, "N", num_nodes);
     SETVANV(&g, "proj_externa", &proj_externa);  // tem tamanho do numero de nos N da rede, TODO - destruir o vetor proj_externo depois de setar estes atributos ? i.e. isso vai desfazer os atributos ?

     GRand *rgen = g_rand_new_with_seed(12345);
    
     double l;

     for(int i = 0; i < num_nodes; i++){

        l = (double) g_rand_double_range(rgen, 0.0, 1.0); 

        if (l <= porcent_inib)           

            gerarSinais(g,"inib", 0, 0, i);
             
        else

            gerarSinais(g, "excit", 0, 0, i);
   
        SETVAN(&g, "prob_ativar", i, 0.0);

     }

     int tamanho = igraph_vector_size(&em_atividade_iniciais);
     int indice;

     for(int i = 0; i < tamanho; i++){

         indice = (int) VECTOR(em_atividade_iniciais)[i];
         SETVAN(&g, "estado", indice, 1);
//         SETGAN(&g, "em_atividade_"+STR(indice), 1);
     }

}

igraph_real_t retornaPeso(igraph_t g, igraph_integer_t noh_de, igraph_integer_t noh_para){
   igraph_integer_t *eid = malloc(sizeof(igraph_integer_t));
   igraph_bool_t error;
   igraph_get_eid( &g, eid, noh_de, noh_para, 1, error);
   int num_arestas = igraph_ecount(&g);

   if( noh_para >= num_arestas || noh_de >= num_arestas ){
       printf("Indice maior que numero de nos da rede");
       return 0;
   }else{
       return EAN(&g, "peso", *eid);
   }

}

void printSinal(igraph_t g, int index){  
   printf("(Indice: %d, Tipo: %s, Estado: %d, Prob_Ativar %f, Ativavel: %d, Recebe Sinal Externo: %d)\n", index, retornaTipo(g,index), (int) retornaEstado(g, index), (double) retornaProb(g, index), (int) retornaAtivavel(g, index), (int) retornaProjExterna(g, index));
}

void printVizinhosSinal(igraph_t g, igraph_adjlist_t adjacency, int index){

   igraph_vector_int_t *vizinhos = igraph_adjlist_get(&adjacency, index);
   int tamanho = igraph_vector_size(vizinhos);

   for(int i = 0; i < tamanho; i++){
          printf("(Indice: %d, Peso: %f, Tipo: %s, Estado: %d, Prob_Ativar %f, Ativavel: %d, Recebe Sinal Externo: %d)\n", VECTOR(*vizinhos)[i], (double) retornaPeso(g, index, VECTOR(*vizinhos)[i]), retornaTipo(g, VECTOR(*vizinhos)[i]), (int) retornaEstado(g, VECTOR(*vizinhos)[i]), (double) retornaProb(g, VECTOR(*vizinhos)[i]), (int) retornaAtivavel(g, VECTOR(*vizinhos)[i]), (int) retornaProjExterna(g, VECTOR(*vizinhos)[i]) );
   }

}
