#ifndef _Perceptlib_h
#define _Perceptlib_h

#include <glib.h>
#include <igraph.h>
#include <stdio.h>

/*typedef struct No_Sinal{
    char *tipo;
    int estado;
    double prob_ativar;
    int ativavel;
    int proj_externa;
    int indice;
    Lista *vizinhos;
    Lista *pesos;
        
} *No_Sinal;*/


/* Listas utilizadas para manipular sinais de nos ao longo da simulacao. Cada Lista aloca as referencias para os No_Sinais de acordo com atividade da rede. Lista nos aloca referencias para todos No_Sinal, servindo como um heap da rede em simulacao. 

typedef struct Rede_percept{

    Lista *nos;
    igraph_vector_t proj_externa; 
    Lista *em_atividade;
    Lista *proximos_em_atividade;
    Lista *podem_entrar_em_atividade;
    Lista *acabaram_atividade;   
    double porcentagem_inibitorios; // numero entre [0,1) determina o tipo de cada individuo inib ou excit. Determinado ao criar a Rede_percept.
    double fator_proj_externa;
  
} *Rede_percept;*/

typedef struct {
    igraph_vector_t em_atividade;
    igraph_vector_t primeiros_vizinhos;
    igraph_vector_t proj_externa;
} *atividade;

igraph_real_t retornaEstado(igraph_t g, int index);

igraph_real_t retornaProb(igraph_t g, int index);

igraph_real_t retornaAtivavel(igraph_t g, int index);

igraph_real_t retornaProjExterna(igraph_t g, int index);

const char *retornaTipo(igraph_t g, int index);

void gerarSinais(igraph_t g, char *tipo, int estado, int ativavel, int index);

igraph_real_t retornaPeso(igraph_t g, igraph_integer_t noh_de, igraph_integer_t noh_para);

void gerarPercept(igraph_t g, double porcent_inib, double fator_proj_externa, int num_nodes, igraph_vector_int_t em_atividade_iniciais, igraph_vector_t proj_externa, atividade ativos);

void printSinal(igraph_t g, int index);

void printVizinhosSinal(igraph_t g, igraph_adjlist_t adjacency, int index);

#endif
