#include "automata0.h"

int main(void){

    igraph_t g;
    float N = 50.0;
    igraph_integer_t Kin = 8.0;
    igraph_bool_t directed = 1;
    igraph_i_set_attribute_table(&igraph_cattribute_table);
    igraph_erdos_renyi_game(&g, IGRAPH_ERDOS_RENYI_GNM, N, N*Kin/2.0, directed, 0);
    int l = (int) N;
    int c = 0;
    int simtime = 500;
    double pmax;
    double sigma = 1.0; // transmissibilidade
    double inib_percent = 0.2; // porcentagem de nos diminuidores de atividade

    igraph_vector_int_t atv_inicial;
    igraph_vector_t proj_externa;
    igraph_vector_init(&atv_inicial, 10);
    igraph_vector_init(&proj_externa, 50);
    igraph_adjlist_t adjlist;
    igraph_adjlist_init(&g, &adjlist, IGRAPH_OUT);

   // igraph_i_set_attribute_table(&igraph_cattribute_table);

    for(int i = 0; i < 50; i++){
          if( i % 3 == 0)
          VECTOR(proj_externa)[i] = 1;
          else
          VECTOR(proj_externa)[i] = 0;               
    }

    for(int i = 0; i < 10; i++){

         int *j = malloc(sizeof(int));
         *j = 0;
         *j = *j + 3*i;
         printf("%d\n",*j);
         VECTOR(atv_inicial)[i] = *j;
      
    }


//    gerarPercept(g, 0.2, 0.4313, l, atv_inicial, proj_externa);

    Automata autom = criarAutomata(g, 2, simtime, 0.2, 0.75, 0.55, atv_inicial, proj_externa, 10320);
    probabilidades(g, autom); 

/*    for (int i = 0; i < 50; i++){
        printSinal(g, i);
        printVizinhosSinal(g, adjlist, i);
    }*/
         
return 0;
}
