#ifndef _Automata_h
#define _Automata_h
#include "perceptlib0.h"

typedef struct Automata{
   
    struct estado *estado;
    int tempo_final;
    double densidade_final;
    int simulation_time;
    int N;
    int num_estados;
    
} *Automata;

struct Automata *criarAutomata(igraph_t *g, int num_estados, const int simulation_time, double porcent_inib, double pmax, double fator_proj_externa, igraph_vector_t *proj_externa, GRand *gen);

double densidade(Automata autom, igraph_vector_int_t *vec);

void destruirAutomata(Automata autom);

void criarPesos(igraph_t *g, double pmax, GRand *gen);

void probabilidades(igraph_t *g, Automata autom, igraph_vector_int_t *ativos, igraph_vector_int_t *primeiros_vizinhos, igraph_vector_int_t *proj_externa, igraph_adjlist_t *adjlist);

void simular(igraph_t *g, Automata autom, igraph_vector_int_t *atv_inicial, igraph_adjlist_t *adjlist, GRand *rgen, char *gravadens);

int compara(char *s, char *t);

#endif
