#include <omp.h>
#include "automata0.h"

int main(void){

    igraph_t g;
    float N = 10000.0;
    igraph_integer_t Kin = 20.0;
    igraph_bool_t directed = 0;
    int l = (int) N;
    int simtime = 5000;
    double sigma = 0.9; // transmissibilidade
    double inib_percent = 0.0; // porcentagem de nos diminuidores de atividade
    double pmax = sigma/(2.0*Kin*(1.0 - inib_percent));
    igraph_i_set_attribute_table(&igraph_cattribute_table);
    igraph_erdos_renyi_game(&g, IGRAPH_ERDOS_RENYI_GNM, N, N*Kin/2.0, directed, 0);
    
    igraph_vector_t proj_externa;
    igraph_vector_init(&proj_externa, l);
    GRand *rgen = g_rand_new_with_seed(2245);
    int v0;
 
    for(int i = 0; i < l; i++){
          /*if( (i % 2 != 0) && (i % 3 != 0) )
          VECTOR(proj_externa)[i] = 1;
          else */
          VECTOR(proj_externa)[i] = 0;               
    }

    igraph_adjlist_t adjlist;
    igraph_adjlist_init(&g, &adjlist, IGRAPH_OUT);
     
    igraph_vector_int_t atv_inicial;
    igraph_vector_int_init(&atv_inicial, 1000);
    
    Automata autom = criarAutomata(&g, 2, simtime, inib_percent, pmax, 0.55, &proj_externa, rgen);    
    char str[10];
//    #pragma omp parallel for
    for(int t = 0; t < 20; t++){


    for(int i = 0; i < 1000; i++){
       
         v0 = (int) g_rand_int_range(rgen, 0, 10000);
         VECTOR(atv_inicial)[i] = v0;
//         mudaEstado(autom->estado,v0,1);
    }

  
    sprintf(str,"output_%d",t);
    simular(&g, autom, &atv_inicial, &adjlist, rgen, str);
    printf("Realizacao %d\n",  t);
    }
return 0;
}
