package MemTest;
use strict; 
use warnings;

##########################################################################

BEGIN 
{
	$ENV{CLASSPATH} .= "/tmp/mem_test";
	$ENV{JAVA_OPTS} .= "-Xms2048M -Xmx2048M";
}

##########################################################################

use Inline
(
	Java				=> 'DATA',
	DIRECTORY			=> "./_inline_java",
);

##########################################################################
# new
sub new 
{
	my $class = shift;
    my $memTest = MemTest::MemTestJava->new();

    my $this =
    {
		memTest		=> $memTest,
    };

	bless($this, $class);	
	return $this;
}

##########################################################################

sub makeString
{
	my $this = shift;
	my $size = shift;
	my $ret = $this->{memTest}->makeString($size);
	return $ret;
}

##########################################################################

1;

__DATA__
__Java__

public class MemTestJava 
{
	MemTest memTest;

	public MemTestJava() 
	{
		try 
		{
			memTest = new MemTest();
		} 
		catch ( Exception ex )
		{
			System.out.println("error - " + ex.getMessage());
		}
	}
	
    public String makeString(int size)
    {
        return memTest.makeString(size);
    }
}

