#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "php.h"

static int le_retref;

ZEND_BEGIN_ARG_INFO_EX(first_arg_force_ref_ret_ref, 0, 1, 0)
	ZEND_ARG_PASS_INFO(1)
ZEND_END_ARG_INFO();

PHP_FUNCTION(retref)
{
	zval **arg;

	if (ZEND_NUM_ARGS()!=1 || zend_get_parameters_ex(1, &arg)==FAILURE) {
		RETURN_FALSE;
	}
	zval_ptr_dtor(return_value_ptr);
	SEPARATE_ZVAL_TO_MAKE_IS_REF(arg);
	ZVAL_ADDREF(*arg);
	*return_value_ptr = *arg;
}

PHP_FUNCTION(retref_el)
{
	zval *array;
	HashPosition pos;
	zval **el;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "a", &array) == FAILURE) {
		return;
	}
	zend_hash_internal_pointer_reset_ex(HASH_OF(array), &pos);
	if (zend_hash_get_current_data_ex(HASH_OF(array), (void **) &el, &pos) == SUCCESS) {
		zval_ptr_dtor(return_value_ptr);
		SEPARATE_ZVAL_TO_MAKE_IS_REF(el);
		ZVAL_ADDREF(*el);
		*return_value_ptr = *el;
		return;
	}
	RETURN_FALSE;
}

function_entry retref_functions[] = {
	PHP_FE(retref,	first_arg_force_ref_ret_ref)
	PHP_FE(retref_el,	first_arg_force_ref_ret_ref)
	{NULL, NULL, NULL}
};

zend_module_entry retref_module_entry = {
#if ZEND_MODULE_API_NO >= 20010901
	STANDARD_MODULE_HEADER,
#endif
	"retref",
	retref_functions,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
#if ZEND_MODULE_API_NO >= 20010901
	"0.0",
#endif
	STANDARD_MODULE_PROPERTIES
};

#ifdef COMPILE_DL_RETREF
ZEND_GET_MODULE(retref)
#endif

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */
