#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "php.h"

static int le_class_const;

PHP_FUNCTION(get_static_property)
{
	char *class_name, *prop_name;
	int class_name_len, prop_name_len;
	zend_class_entry **pce;
	zval *val;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ss", &class_name, &class_name_len, &prop_name, &prop_name_len) == FAILURE) {
		WRONG_PARAM_COUNT;
	}
	if (zend_lookup_class(class_name, class_name_len, &pce TSRMLS_CC) == FAILURE) {
		RETURN_FALSE;
	}
	val = zend_read_static_property(*pce, prop_name, prop_name_len, 0 TSRMLS_CC);
	if (val) {
		RETURN_ZVAL(val, 1, 0);
	} else {
		RETURN_FALSE;
	}
}

PHP_FUNCTION(set_static_property)
{
	char *class_name, *prop_name;
	int class_name_len, prop_name_len;
	zend_class_entry **pce;
	zval *value;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ssz", &class_name, &class_name_len, &prop_name, &prop_name_len, &value) == FAILURE) {
		WRONG_PARAM_COUNT;
	}
	if (zend_lookup_class(class_name, class_name_len, &pce TSRMLS_CC) == FAILURE) {
		RETURN_FALSE;
	}
	if (zend_update_static_property(*pce, prop_name, prop_name_len, value TSRMLS_CC) == SUCCESS) {
		RETURN_TRUE;
	} else {
		RETURN_FALSE;
	}
}


function_entry class_const_functions[] = {
	PHP_FE(get_static_property, NULL)
	PHP_FE(set_static_property, NULL)
	{NULL, NULL, NULL}
};

PHP_MINIT_FUNCTION(class_const)
{
	zend_class_entry ce;
	zend_class_entry *pce, *t1;

	INIT_CLASS_ENTRY(ce, "TestClass", NULL);
	pce = zend_register_internal_class(&ce TSRMLS_CC);

	zend_declare_property_string(pce, "public_prop", sizeof("public_prop")-1, "public_prop", ZEND_ACC_PUBLIC TSRMLS_CC);
	zend_declare_property_string(pce, "protected_prop", sizeof("protected_prop")-1, "protected_prop", ZEND_ACC_PROTECTED TSRMLS_CC);
	zend_declare_property_string(pce, "private_prop", sizeof("private_prop")-1, "private_prop", ZEND_ACC_PRIVATE TSRMLS_CC);
	zend_declare_property_string(pce, "public_static_prop", sizeof("public_static_prop")-1, "public_static_prop", ZEND_ACC_PUBLIC | ZEND_ACC_STATIC TSRMLS_CC);
	zend_declare_property_string(pce, "protected_static_prop", sizeof("protected_static_prop")-1, "protected_static_prop", ZEND_ACC_PROTECTED | ZEND_ACC_STATIC TSRMLS_CC);
	zend_declare_property_string(pce, "private_static_prop", sizeof("private_static_prop")-1, "private_static_prop", ZEND_ACC_PRIVATE | ZEND_ACC_STATIC TSRMLS_CC);
	zend_declare_class_constant_string(pce, "cons", sizeof("cons")-1, "cons" TSRMLS_CC);

	INIT_CLASS_ENTRY(ce, "TestClass1", NULL);
	t1 = zend_register_internal_class(&ce TSRMLS_CC);
	zend_declare_property_string(t1, "s1", sizeof("s1")-1, "0", ZEND_ACC_PUBLIC | ZEND_ACC_STATIC TSRMLS_CC);
	
	INIT_CLASS_ENTRY(ce, "TestClass2", NULL);
	pce = zend_register_internal_class_ex(&ce, t1, NULL TSRMLS_CC);
	zend_declare_property_string(pce, "s2", sizeof("s2")-1, "s2", ZEND_ACC_PUBLIC | ZEND_ACC_STATIC TSRMLS_CC);

	INIT_CLASS_ENTRY(ce, "TestClass3", NULL);
	pce = zend_register_internal_class_ex(&ce, t1, NULL TSRMLS_CC);
	zend_declare_property_string(pce, "s3", sizeof("s3")-1, "s3", ZEND_ACC_PUBLIC | ZEND_ACC_STATIC TSRMLS_CC);

	return SUCCESS;
}

PHP_MSHUTDOWN_FUNCTION(class_const)
{
	return SUCCESS;
}

zend_module_entry class_const_module_entry = {
#if ZEND_MODULE_API_NO >= 20010901
	STANDARD_MODULE_HEADER,
#endif
	"class_const",
	class_const_functions,
	PHP_MINIT(class_const),
	PHP_MSHUTDOWN(class_const),
	NULL,
	NULL,
	NULL,
#if ZEND_MODULE_API_NO >= 20010901
	"0.0",
#endif
	STANDARD_MODULE_PROPERTIES
};

#ifdef COMPILE_DL_CLASS_CONST
ZEND_GET_MODULE(class_const)
#endif

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */
